/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.util.OSUserConverter;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.dbc.Assertions;

public class JiraServiceContextImpl
implements JiraServiceContext {
    private final ErrorCollection errorCollection;
    private final User user;
    private I18nHelper i18nHelper;
    private com.opensymphony.user.User osUser;

    public JiraServiceContextImpl(User user) {
        this(user, (ErrorCollection)new SimpleErrorCollection());
    }

    public JiraServiceContextImpl(com.opensymphony.user.User user) {
        this(user, (ErrorCollection)new SimpleErrorCollection());
    }

    public JiraServiceContextImpl(User user, ErrorCollection errorCollection) {
        this(user, errorCollection, null);
    }

    public JiraServiceContextImpl(com.opensymphony.user.User user, ErrorCollection errorCollection) {
        this(user, errorCollection, (I18nHelper)null);
    }

    public JiraServiceContextImpl(User user, ErrorCollection errorCollection, I18nHelper i18nHelper) {
        this.errorCollection = Assertions.notNull("errorCollection", errorCollection);
        this.user = user;
        this.i18nHelper = i18nHelper;
    }

    public JiraServiceContextImpl(com.opensymphony.user.User user, ErrorCollection errorCollection, I18nHelper i18nHelper) {
        this.errorCollection = Assertions.notNull("errorCollection", errorCollection);
        this.user = user;
        this.osUser = user;
        this.i18nHelper = i18nHelper;
    }

    @Override
    public ErrorCollection getErrorCollection() {
        return this.errorCollection;
    }

    @Override
    public com.opensymphony.user.User getUser() {
        if (this.osUser == null) {
            this.osUser = OSUserConverter.convertToOSUser(this.user);
        }
        return this.osUser;
    }

    @Override
    public User getLoggedInUser() {
        return this.user;
    }

    @Override
    public I18nHelper getI18nBean() {
        if (this.i18nHelper == null) {
            this.i18nHelper = ComponentAccessor.getI18nHelperFactory().getInstance(this.user);
        }
        return this.i18nHelper;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JiraServiceContextImpl that = (JiraServiceContextImpl)o;
        if (this.errorCollection != null ? !this.errorCollection.equals(that.errorCollection) : that.errorCollection != null) {
            return false;
        }
        return !(this.user != null ? !this.user.equals(that.user) : that.user != null);
    }

    public int hashCode() {
        int result = this.errorCollection != null ? this.errorCollection.hashCode() : 0;
        result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("User:");
        if (this.user == null) {
            sb.append("[anonymous]");
        } else {
            sb.append(this.user.getName());
        }
        sb.append(" ");
        sb.append(this.errorCollection.toString());
        return sb.toString();
    }
}

