/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.query.clause;

import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClausePrecedence;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class MultiClause
implements Clause {
    private final List<Clause> clauses;

    protected MultiClause(Collection<? extends Clause> clauses) {
        Assertions.containsNoNulls("clauses", clauses);
        this.clauses = Collections.unmodifiableList(new ArrayList<Clause>(clauses));
    }

    @Override
    public List<Clause> getClauses() {
        return this.clauses;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        ClausePrecedence currentPrecedence = ClausePrecedence.getPrecedence(this);
        Iterator<Clause> clauseIterator = this.getClauses().iterator();
        while (clauseIterator.hasNext()) {
            Clause clause = clauseIterator.next();
            ClausePrecedence childPrecedence = ClausePrecedence.getPrecedence(clause);
            if (childPrecedence.getValue() < currentPrecedence.getValue()) {
                sb.append("( ");
            }
            sb.append(((Object)clause).toString());
            if (childPrecedence.getValue() < currentPrecedence.getValue()) {
                sb.append(" )");
            }
            if (!clauseIterator.hasNext()) continue;
            sb.append(" ").append(this.getName()).append(" ");
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiClause that = (MultiClause)o;
        return !(this.clauses != null ? !((Object)this.clauses).equals(that.clauses) : that.clauses != null);
    }

    public int hashCode() {
        return this.clauses != null ? ((Object)this.clauses).hashCode() : 0;
    }
}

