/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.changehistory;

import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ChangeHistoryFieldConstants {
    private final List<String> managedFieldConstantTypes = Lists.newArrayList((Object[])new String[]{"status", "priority", "resolution"});
    private final LazyReference<Map<String, Multimap<String, String>>> ref = new LazyReference<Map<String, Multimap<String, String>>>(){

        protected Map<String, Multimap<String, String>> create() throws Exception {
            HashMap map = Maps.newHashMap();
            TreeMultimap multiMap = TreeMultimap.create();
            multiMap.put((Object)"unresolved", (Object)"-1");
            map.put("resolution", multiMap);
            return map;
        }
    };

    public void addChangeHistoryFieldConstant(String field, String value, String id) {
        field = Assertions.notNull("field", field).toLowerCase();
        value = Assertions.notNull("value", value).toLowerCase();
        if (this.managedFieldConstantTypes.contains(field)) {
            String string = id = id != null ? id.toLowerCase() : id;
            if (!((Map)this.ref.get()).containsKey(field)) {
                ((Map)this.ref.get()).put(field, TreeMultimap.create());
            } else if (!((Multimap)((Map)this.ref.get()).get(field)).containsKey((Object)value)) {
                ((Multimap)((Map)this.ref.get()).get(field)).put((Object)value, (Object)id);
            }
        }
    }

    public Set<String> getIdsForField(String field, String value) {
        field = Assertions.notNull("field", field).toLowerCase();
        value = Assertions.notNull("value", value).toLowerCase();
        return ((Map)this.ref.get()).get(field) != null ? ImmutableSet.copyOf((Iterable)((Multimap)((Map)this.ref.get()).get(field)).get((Object)value)) : ImmutableSet.of();
    }
}

