/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.operation;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperationImpl;
import com.atlassian.jira.issue.operation.ScreenableIssueOperation;
import com.atlassian.jira.issue.operation.ScreenableSingleIssueOperationImpl;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;

public class IssueOperations {
    public static final ScreenableIssueOperation CREATE_ISSUE_OPERATION = new ScreenableSingleIssueOperationImpl(0L, "admin.issue.operations.create", "admin.issue.operations.create.desc");
    public static final ScreenableIssueOperation EDIT_ISSUE_OPERATION = new ScreenableSingleIssueOperationImpl(1L, "admin.issue.operations.edit", "admin.issue.operations.edit.desc");
    public static final ScreenableIssueOperation VIEW_ISSUE_OPERATION = new ScreenableSingleIssueOperationImpl(2L, "admin.issue.operations.view", "admin.issue.operations.view.desc");
    public static final IssueOperation MOVE_ISSUE_OPERATION = new IssueOperationImpl("admin.issue.operations.move", "admin.issue.operations.move.desc");
    private static final Map<Long, ScreenableIssueOperation> SCREENABLE_ISSUE_OPERATIONS = ImmutableMap.of((Object)CREATE_ISSUE_OPERATION.getId(), (Object)CREATE_ISSUE_OPERATION, (Object)EDIT_ISSUE_OPERATION.getId(), (Object)EDIT_ISSUE_OPERATION, (Object)VIEW_ISSUE_OPERATION.getId(), (Object)VIEW_ISSUE_OPERATION);

    public static Collection getIssueOperations() {
        return SCREENABLE_ISSUE_OPERATIONS.values();
    }

    public static ScreenableIssueOperation getIssueOperation(Long id) {
        return SCREENABLE_ISSUE_OPERATIONS.get(id);
    }

    public static String getText(String key) {
        return ComponentAccessor.getJiraAuthenticationContext().getI18nHelper().getText(key);
    }
}

