/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.project.version;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.bc.project.version.RemoveVersionAction;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.util.ErrorCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Set;

public interface VersionService {
    public static final VersionAction REMOVE = new RemoveVersionAction();

    public ServiceOutcome<Version> setVersionDetails(User var1, Version var2, String var3, String var4);

    public ServiceOutcome<Version> setReleaseDate(User var1, Version var2, Date var3);

    public ServiceOutcome<Version> setReleaseDate(User var1, Version var2, String var3);

    public ValidationResult validateDelete(JiraServiceContext var1, Long var2, VersionAction var3, VersionAction var4);

    public void delete(JiraServiceContext var1, ValidationResult var2);

    public ValidationResult validateMerge(JiraServiceContext var1, Long var2, Long var3);

    public void merge(JiraServiceContext var1, ValidationResult var2);

    public VersionResult getVersionById(com.opensymphony.user.User var1, Project var2, Long var3);

    public VersionResult getVersionById(User var1, Project var2, Long var3);

    public VersionResult getVersionById(com.opensymphony.user.User var1, Long var2);

    public VersionResult getVersionById(User var1, Long var2);

    public VersionResult getVersionByProjectAndName(com.opensymphony.user.User var1, Project var2, String var3);

    public VersionResult getVersionByProjectAndName(User var1, Project var2, String var3);

    public VersionsResult getVersionsByProject(com.opensymphony.user.User var1, Project var2);

    public VersionsResult getVersionsByProject(User var1, Project var2);

    public CreateVersionValidationResult validateCreateVersion(com.opensymphony.user.User var1, Project var2, String var3, String var4, String var5, Long var6);

    public CreateVersionValidationResult validateCreateVersion(User var1, Project var2, String var3, String var4, String var5, Long var6);

    public CreateVersionValidationResult validateCreateVersion(User var1, Project var2, String var3, Date var4, String var5, Long var6);

    public Version createVersion(com.opensymphony.user.User var1, CreateVersionValidationResult var2);

    public Version createVersion(User var1, CreateVersionValidationResult var2);

    public ReleaseVersionValidationResult validateReleaseVersion(com.opensymphony.user.User var1, Version var2, Date var3);

    public ReleaseVersionValidationResult validateReleaseVersion(User var1, Version var2, Date var3);

    public ReleaseVersionValidationResult validateReleaseVersion(User var1, Version var2, String var3);

    public ReleaseVersionValidationResult validateUnreleaseVersion(com.opensymphony.user.User var1, Version var2, Date var3);

    public ReleaseVersionValidationResult validateUnreleaseVersion(User var1, Version var2, Date var3);

    public ReleaseVersionValidationResult validateUnreleaseVersion(User var1, Version var2, String var3);

    public Version releaseVersion(ReleaseVersionValidationResult var1);

    public void moveUnreleasedToNewVersion(User var1, Version var2, Version var3);

    public Version unreleaseVersion(ReleaseVersionValidationResult var1);

    public ArchiveVersionValidationResult validateArchiveVersion(com.opensymphony.user.User var1, Version var2);

    public ArchiveVersionValidationResult validateArchiveVersion(User var1, Version var2);

    public ArchiveVersionValidationResult validateUnarchiveVersion(com.opensymphony.user.User var1, Version var2);

    public ArchiveVersionValidationResult validateUnarchiveVersion(User var1, Version var2);

    public Version archiveVersion(ArchiveVersionValidationResult var1);

    public Version unarchiveVersion(ArchiveVersionValidationResult var1);

    public boolean isOverdue(Version var1);

    public MoveVersionValidationResult validateMoveToStartVersionSequence(User var1, long var2);

    public MoveVersionValidationResult validateIncreaseVersionSequence(User var1, long var2);

    public MoveVersionValidationResult validateDecreaseVersionSequence(User var1, long var2);

    public MoveVersionValidationResult validateMoveToEndVersionSequence(User var1, long var2);

    public MoveVersionValidationResult validateMoveVersionAfter(User var1, long var2, Long var4);

    public void moveToStartVersionSequence(MoveVersionValidationResult var1);

    public void increaseVersionSequence(MoveVersionValidationResult var1);

    public void decreaseVersionSequence(MoveVersionValidationResult var1);

    public void moveToEndVersionSequence(MoveVersionValidationResult var1);

    public void moveVersionAfter(MoveVersionValidationResult var1);

    public long getFixIssuesCount(Version var1);

    public long getAffectsIssuesCount(Version var1);

    public static interface VersionAction {
        public boolean isSwap();

        public Long getSwapVersionId();
    }

    public static class MoveVersionValidationResult
    extends AbstractVersionResult {
        private Long scheduleAfterVersion;
        private final Set<Reason> reasons;

        public MoveVersionValidationResult(ErrorCollection errorCollection, Set<Reason> reasons) {
            super(errorCollection);
            this.reasons = Collections.unmodifiableSet(reasons);
        }

        public MoveVersionValidationResult(ErrorCollection errorCollection, Version version) {
            super(errorCollection, version);
            this.reasons = Collections.emptySet();
        }

        public MoveVersionValidationResult(ErrorCollection errorCollection, Version version, Long scheduleAfterVersion) {
            super(errorCollection, version);
            this.reasons = Collections.emptySet();
            this.scheduleAfterVersion = scheduleAfterVersion;
        }

        public Set<Reason> getReasons() {
            return this.reasons;
        }

        public Long getScheduleAfterVersion() {
            return this.scheduleAfterVersion;
        }

        public static enum Reason {
            FORBIDDEN,
            NOT_FOUND,
            SCHEDULE_AFTER_VERSION_NOT_FOUND;

        }
    }

    public static class ArchiveVersionValidationResult
    extends AbstractVersionResult {
        public ArchiveVersionValidationResult(ErrorCollection errorCollection) {
            super(errorCollection);
        }

        public ArchiveVersionValidationResult(ErrorCollection errorCollection, Version version) {
            super(errorCollection, version);
        }
    }

    public static class ReleaseVersionValidationResult
    extends AbstractVersionResult {
        private final Date releaseDate;

        public ReleaseVersionValidationResult(ErrorCollection errorCollection) {
            this(errorCollection, null, null);
        }

        public ReleaseVersionValidationResult(ErrorCollection errorCollection, Version version, Date releaseDate) {
            super(errorCollection, version);
            this.releaseDate = releaseDate;
        }

        public Date getReleaseDate() {
            return this.releaseDate;
        }
    }

    public static class VersionsResult
    extends ServiceResultImpl {
        private final Collection<Version> versions;

        public VersionsResult(ErrorCollection errorCollection) {
            this(errorCollection, Collections.emptyList());
        }

        public VersionsResult(ErrorCollection errorCollection, Collection<Version> versions) {
            super(errorCollection);
            this.versions = versions;
        }

        public Collection<Version> getVersions() {
            return this.versions;
        }
    }

    public static class VersionResult
    extends AbstractVersionResult {
        public VersionResult(ErrorCollection errorCollection) {
            super(errorCollection);
        }

        public VersionResult(ErrorCollection errorCollection, Version version) {
            super(errorCollection, version);
        }
    }

    public static abstract class AbstractVersionResult
    extends ServiceResultImpl {
        private final Version version;

        public AbstractVersionResult(ErrorCollection errorCollection) {
            this(errorCollection, null);
        }

        public AbstractVersionResult(ErrorCollection errorCollection, Version version) {
            super(errorCollection);
            this.version = version;
        }

        public Version getVersion() {
            return this.version;
        }
    }

    public static class CreateVersionValidationResult
    extends ServiceResultImpl {
        private final Project project;
        private final String versionName;
        private final Date releaseDate;
        private final String description;
        private final Long scheduleAfterVersion;
        private final Set<Reason> reasons;

        public CreateVersionValidationResult(ErrorCollection errorCollection, Set<Reason> reasons) {
            super(errorCollection);
            this.reasons = Collections.unmodifiableSet(reasons);
            this.project = null;
            this.versionName = null;
            this.releaseDate = null;
            this.description = null;
            this.scheduleAfterVersion = null;
        }

        public CreateVersionValidationResult(ErrorCollection errorCollection, Project project, String versionName, Date releaseDate, String description, Long scheduleAfterVersion) {
            super(errorCollection);
            this.reasons = Collections.emptySet();
            this.project = project;
            this.versionName = versionName;
            this.releaseDate = releaseDate;
            this.description = description;
            this.scheduleAfterVersion = scheduleAfterVersion;
        }

        public Project getProject() {
            return this.project;
        }

        public String getVersionName() {
            return this.versionName;
        }

        public Date getReleaseDate() {
            return this.releaseDate;
        }

        public String getDescription() {
            return this.description;
        }

        public Long getScheduleAfterVersion() {
            return this.scheduleAfterVersion;
        }

        public Set<Reason> getReasons() {
            return this.reasons;
        }

        public static enum Reason {
            FORBIDDEN,
            BAD_PROJECT,
            BAD_NAME,
            DUPLICATE_NAME,
            BAD_RELEASE_DATE,
            VERSION_NAME_TOO_LONG;

        }
    }

    public static interface ValidationResult {
        public boolean isValid();

        public Version getVersionToDelete();

        public Version getFixSwapVersion();

        public Version getAffectsSwapVersion();

        public Set<Reason> getReasons();

        public ErrorCollection getErrorCollection();

        public static enum Reason {
            FORBIDDEN,
            NOT_FOUND,
            SWAP_TO_VERSION_INVALID;

        }
    }
}

