/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.collect;

import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.collect.LazyMapEntry;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class CompositeMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    private final Map<K, V> one;
    private final Map<K, V> two;
    private final Set<K> removed = Sets.newHashSet();

    public static <K, V> Map<K, V> of(Map<K, V> one, Map<K, V> two) {
        return new CompositeMap<K, V>(one, two);
    }

    CompositeMap(Map<K, V> one, Map<K, V> two) {
        this.one = Assertions.notNull("one", one);
        this.two = Assertions.notNull("two", two);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return CollectionUtil.transformSet(this.keySet(), new EntryTransformer());
    }

    @Override
    public V get(Object key) {
        if (this.removed.contains(key)) {
            return null;
        }
        return this.one.containsKey(key) ? this.one.get(key) : this.two.get(key);
    }

    @Override
    public Set<K> keySet() {
        return Sets.filter((Set)Sets.union(this.one.keySet(), this.two.keySet()), (Predicate)new Predicate<K>(){

            public boolean apply(K key) {
                return !CompositeMap.this.removed.contains(key);
            }
        });
    }

    @Override
    public boolean containsKey(Object key) {
        return !this.removed.contains(key) && (this.one.containsKey(key) || this.two.containsKey(key));
    }

    @Override
    public boolean isEmpty() {
        return this.one.isEmpty() && this.two.isEmpty();
    }

    @Override
    public V put(K key, V value) {
        this.removed.remove(key);
        return this.one.put(key, value);
    }

    @Override
    public V remove(Object key) {
        V result = this.get(key);
        Object k = key;
        this.removed.add(k);
        return result;
    }

    class EntryTransformer
    implements Function<K, Map.Entry<K, V>> {
        EntryTransformer() {
        }

        @Override
        public Map.Entry<K, V> get(K key) {
            return new LazyMapEntry(CompositeMap.this, key);
        }
    }
}

