/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.util;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.util.concurrent.CopyOnWriteMap;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.concurrent.ConcurrentMap;
import javax.mail.internet.MailDateFormat;
import org.apache.log4j.Logger;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class OutlookDate {
    private static final Logger log = Logger.getLogger(OutlookDate.class);
    private static final String FORMAT_ISO8601 = "yyyy-MM-dd'T'HH-mm";
    private static final String FORMAT_ISO8601_DATE = "yyyy-MM-dd";
    private static final DateTimeFormatter RSS_RFC822_FORMAT = DateTimeFormat.forPattern((String)"EEE, d MMM yyyy HH:mm:ss Z").withLocale(Locale.US);
    public static final long SECOND = 1000L;
    public static final long MINUTE = 60000L;
    public static final long HOUR = 3600000L;
    public static final long DAY = 86400000L;
    public static final int TODAY = 0;
    public static final int YESTERDAY = 1;
    public static final int THIS_WEEK = 2;
    public static final int OTHER = 3;
    private final Locale locale;
    private final ApplicationProperties applicationProperties;
    private final FormatCache cache = new FormatCache();
    private final I18nHelper.BeanFactory i18nHelperFactory;

    public OutlookDate(Locale locale, ApplicationProperties applicationProperties, I18nHelper.BeanFactory i18nHelperFactory) {
        this.locale = locale;
        this.applicationProperties = applicationProperties;
        this.i18nHelperFactory = i18nHelperFactory;
    }

    public OutlookDate(Locale locale) {
        this(locale, ComponentAccessor.getApplicationProperties(), ComponentAccessor.getI18nHelperFactory());
    }

    public OutlookDate(Locale locale, ApplicationProperties applicationProperties) {
        this(locale, applicationProperties, OutlookDate.i18nFactory(applicationProperties));
    }

    private static I18nHelper.BeanFactory i18nFactory(ApplicationProperties applicationProperties) {
        if (applicationProperties == null) {
            return null;
        }
        return ComponentAccessor.getI18nHelperFactory();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String formatIso8601(Date date) {
        return DateTimeFormat.forPattern((String)FORMAT_ISO8601).print(date.getTime());
    }

    public String formatIso8601Date(Date date) {
        return DateTimeFormat.forPattern((String)FORMAT_ISO8601_DATE).print(date.getTime());
    }

    public String formatDMY(Date date) {
        return this.formatterForKey("jira.lf.date.dmy").print(date.getTime());
    }

    public String formatDMYHMS(Date date) {
        return this.createFormatterComplete().print(date.getTime());
    }

    public String formatTime(Date date) {
        return this.createFormatterTime().print(date.getTime());
    }

    public String formatDay(Date date) {
        return this.createFormatterDay().print(date.getTime());
    }

    public String formatDatePicker(Date date) {
        return this.createDatePickerFormat().print(date.getTime());
    }

    public String formatDateTimePicker(Date date) {
        return this.createDateTimePickerFormat().print(date.getTime());
    }

    public static String formatRss(Date date) {
        return OutlookDate.formatRssRfc822(date);
    }

    public static String formatRssRfc822(Date date) {
        return date == null ? "" : RSS_RFC822_FORMAT.print(date.getTime());
    }

    public static Date parseRss(String rssDate) throws ParseException {
        return new MailDateFormat().parse(rssDate);
    }

    public String format() {
        return this.format(new Date());
    }

    public String format(Date date) {
        int daysAgo = this.daysAgo(date);
        boolean formatterRelative = this.applicationProperties.getOption("jira.lf.date.relativize");
        if (formatterRelative && daysAgo == 0) {
            return this.getI18nHelper().getText("common.concepts.today", this.createFormatterTime().print(date.getTime()));
        }
        if (formatterRelative && daysAgo == 1) {
            return this.getI18nHelper().getText("common.concepts.yesterday", this.createFormatterTime().print(date.getTime()));
        }
        if (formatterRelative && daysAgo == 2) {
            return this.createFormatterDay().print(date.getTime());
        }
        return this.createFormatterComplete().print(date.getTime());
    }

    public String formatSmart(Date date, SmartFormatterModes mode) {
        return this.formatSmart(date, new Date(), mode);
    }

    String formatSmart(Date date, Date referenceDate, SmartFormatterModes mode) {
        boolean formatterRelative = this.applicationProperties.getOption("jira.lf.date.relativize");
        String dateI18nKey = SmartFormatter.getDayI18nKey(date, referenceDate);
        if (formatterRelative && dateI18nKey != null) {
            String dateString = mode != SmartFormatterModes.HIDE_TIME ? this.createFormatterTime().print(date.getTime()) : "";
            return this.getI18nHelper().getText(dateI18nKey, dateString);
        }
        DateTimeFormatter dateFormat = mode == SmartFormatterModes.SHOW_TIME ? this.createFormatterComplete() : this.createFormatterDMY();
        return dateFormat.print(date.getTime());
    }

    @Deprecated
    public String format(Date date, Locale remoteUserLocale) {
        log.warn((Object)"Deprecated: Please use OutlookDate.format(Date date) instead");
        return this.format(date);
    }

    public Date getNow() {
        return new Date(System.currentTimeMillis());
    }

    public int daysAgo(Date date) {
        return this.daysAgo(date, new Date());
    }

    public int daysAgo(Date theDate, Date theReferenceDate) {
        LocalDate refDt = new LocalDate(OutlookDate.getTimeAtEndOfDate(theReferenceDate));
        LocalDate timeDt = new LocalDate(theDate.getTime());
        int daysBetween = Days.daysBetween((ReadablePartial)timeDt, (ReadablePartial)refDt).getDays();
        if (daysBetween == 0) {
            return 0;
        }
        if (daysBetween == 1) {
            return 1;
        }
        if (daysBetween > 1 && daysBetween < 7) {
            return 2;
        }
        return 3;
    }

    public Date parseCompleteDateTime(String value) throws ParseException {
        return OutlookDate.parse(this.createFormatterComplete(), value);
    }

    public Date parseDatePicker(String value) throws ParseException {
        try {
            return OutlookDate.parse(this.createDatePickerFormat(), value);
        }
        catch (ParseException e) {
            return this.parseDateTimePicker(value);
        }
    }

    public Date parseDateTimePicker(String value) throws ParseException {
        return OutlookDate.parse(this.createDateTimePickerFormat(), value);
    }

    private static Date parse(DateTimeFormatter format, String value) throws ParseException {
        try {
            return format.parseDateTime(value).toDate();
        }
        catch (IllegalArgumentException e) {
            throw new ParseException(e.getMessage(), 0);
        }
    }

    public String getDatePickerFormat() {
        return this.applicationProperties.getDefaultBackedString("jira.date.picker.java.format");
    }

    public String getDatePickerFormatSample(Date date) {
        return this.createDatePickerFormat().print(date.getTime());
    }

    public String getDateTimePickerFormatSample(Date date) {
        return this.createDateTimePickerFormat().print(date.getTime());
    }

    public boolean isDatePickerDate(String value) {
        if (value == null) {
            return false;
        }
        try {
            this.parseDatePicker(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public String getDateTimePickerFormat() {
        return this.applicationProperties.getDefaultBackedString("jira.date.time.picker.java.format");
    }

    public String getCompleteDateTimeFormat() {
        return this.applicationProperties.getDefaultBackedString("jira.lf.date.complete");
    }

    public DateFormat getCompleteDateFormat() {
        return new SimpleDateFormat(this.getCompleteDateTimeFormat(), this.locale);
    }

    private DateTimeFormatter createDateTimePickerFormat() {
        return this.formatterForKey("jira.date.time.picker.java.format");
    }

    private DateTimeFormatter createFormatterTime() {
        return this.formatterForKey("jira.lf.date.time");
    }

    private DateTimeFormatter createFormatterDay() {
        return this.formatterForKey("jira.lf.date.day");
    }

    private DateTimeFormatter createFormatterDMY() {
        return this.formatterForKey("jira.lf.date.dmy");
    }

    private DateTimeFormatter createFormatterComplete() {
        return this.formatter(this.getCompleteDateTimeFormat());
    }

    private DateTimeFormatter createDatePickerFormat() {
        return this.formatter(this.getDatePickerFormat());
    }

    private DateTimeFormatter formatterForKey(String key) {
        return this.formatter(this.applicationProperties.getDefaultBackedString(key));
    }

    private DateTimeFormatter formatter(String pattern) {
        return this.cache.get(pattern);
    }

    private static long getTimeAtEndOfDate(Date referenceDate) {
        GregorianCalendar startOfReference = new GregorianCalendar();
        startOfReference.setTime(referenceDate);
        startOfReference.set(14, 999);
        startOfReference.set(13, 59);
        startOfReference.set(12, 59);
        startOfReference.set(11, 23);
        return startOfReference.getTime().getTime();
    }

    private I18nHelper getI18nHelper() {
        return this.i18nHelperFactory.getInstance(this.getLocale());
    }

    final class FormatCache
    implements Function<String, DateTimeFormatter> {
        ConcurrentMap<String, DateTimeFormatter> map = CopyOnWriteMap.newHashMap();

        FormatCache() {
        }

        @Override
        public DateTimeFormatter get(String pattern) {
            DateTimeFormatter result = (DateTimeFormatter)this.map.get(pattern);
            while (result == null) {
                this.map.putIfAbsent(pattern, DateTimeFormat.forPattern((String)pattern).withLocale(OutlookDate.this.locale));
                result = (DateTimeFormatter)this.map.get(pattern);
            }
            return result;
        }
    }

    static class SmartFormatter {
        SmartFormatter() {
        }

        static String getDayI18nKey(Date date) {
            return SmartFormatter.getDayI18nKey(date, new Date());
        }

        static String getDayI18nKey(Date theDate, Date referenceDate) {
            LocalDate timeDt;
            LocalDate refDt = SmartFormatter.createLocalDate(referenceDate);
            int daysBetween = Days.daysBetween((ReadablePartial)refDt, (ReadablePartial)(timeDt = SmartFormatter.createLocalDate(theDate))).getDays();
            if (daysBetween < -7) {
                return null;
            }
            if (daysBetween < -1) {
                return "common.date.relative.days.last." + timeDt.dayOfWeek().get();
            }
            if (daysBetween == -1) {
                return "common.concepts.yesterday";
            }
            if (daysBetween == 0) {
                return "common.concepts.today";
            }
            if (daysBetween == 1) {
                return "common.concepts.tomorrow";
            }
            if (daysBetween <= 7) {
                return "common.date.relative.days.next." + timeDt.dayOfWeek().get();
            }
            return null;
        }

        private static LocalDate createLocalDate(Date date) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            return new LocalDate(cal.get(1), cal.get(2) + 1, cal.get(5));
        }
    }

    public static enum SmartFormatterModes {
        SHOW_TIME,
        HIDE_TIME,
        SHOW_TIME_ONLY_ON_DAYS;

    }
}

