/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security;

import com.atlassian.jira.component.ComponentAccessor;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;

public final class Permissions {
    public static final int ADMINISTER = 0;
    public static final int USE = 1;
    public static final int SYSTEM_ADMIN = 44;
    public static final int PROJECT_ADMIN = 23;
    public static final int BROWSE = 10;
    public static final int CREATE_ISSUE = 11;
    public static final int EDIT_ISSUE = 12;
    public static final int ASSIGN_ISSUE = 13;
    public static final int RESOLVE_ISSUE = 14;
    public static final int COMMENT_ISSUE = 15;
    public static final int DELETE_ISSUE = 16;
    public static final int ASSIGNABLE_USER = 17;
    public static final int CLOSE_ISSUE = 18;
    public static final int CREATE_ATTACHMENT = 19;
    public static final int WORK_ISSUE = 20;
    public static final int LINK_ISSUE = 21;
    public static final int CREATE_SHARED_OBJECTS = 22;
    public static final int MANAGE_GROUP_FILTER_SUBSCRIPTIONS = 24;
    public static final int COMMENT_EDIT_ALL = 34;
    public static final int COMMENT_EDIT_OWN = 35;
    public static final int MOVE_ISSUE = 25;
    public static final int SET_ISSUE_SECURITY = 26;
    public static final int USER_PICKER = 27;
    public static final int SCHEDULE_ISSUE = 28;
    public static final int VIEW_VERSION_CONTROL = 29;
    public static final int MODIFY_REPORTER = 30;
    public static final int VIEW_VOTERS_AND_WATCHERS = 31;
    public static final int MANAGE_WATCHER_LIST = 32;
    public static final int BULK_CHANGE = 33;
    public static final int COMMENT_DELETE_ALL = 36;
    public static final int COMMENT_DELETE_OWN = 37;
    public static final int ATTACHMENT_DELETE_ALL = 38;
    public static final int ATTACHMENT_DELETE_OWN = 39;
    public static final int WORKLOG_EDIT_OWN = 40;
    public static final int WORKLOG_EDIT_ALL = 41;
    public static final int WORKLOG_DELETE_OWN = 42;
    public static final int WORKLOG_DELETE_ALL = 43;
    public static final int MAX_PERMISSION = 44;

    public static Set<Integer> getUsePermissions() {
        TreeSet<Integer> ret = new TreeSet<Integer>();
        ret.add(0);
        ret.add(1);
        ret.add(44);
        return Collections.unmodifiableSet(ret);
    }

    public static int getType(String permName) {
        if (StringUtils.isBlank((String)permName)) {
            return -1;
        }
        String perm = permName.toLowerCase();
        if (perm.startsWith("admin")) {
            return 0;
        }
        if (perm.startsWith("use")) {
            return 1;
        }
        if (perm.startsWith("sysadmin")) {
            return 44;
        }
        if (perm.startsWith("project")) {
            return 23;
        }
        if (perm.startsWith("browse")) {
            return 10;
        }
        if (perm.startsWith("create")) {
            return 11;
        }
        if (perm.startsWith("edit")) {
            return 12;
        }
        if (perm.startsWith("update")) {
            return 12;
        }
        if (perm.startsWith("scheduleissue")) {
            return 28;
        }
        if (perm.startsWith("assignable")) {
            return 17;
        }
        if (perm.startsWith("assign")) {
            return 13;
        }
        if (perm.startsWith("resolv")) {
            return 14;
        }
        if (perm.startsWith("close")) {
            return 18;
        }
        if (perm.startsWith("worklogeditall")) {
            return 41;
        }
        if (perm.startsWith("worklogeditown")) {
            return 40;
        }
        if (perm.startsWith("worklogdeleteown")) {
            return 42;
        }
        if (perm.startsWith("worklogdeleteall")) {
            return 43;
        }
        if (perm.startsWith("work")) {
            return 20;
        }
        if (perm.startsWith("link")) {
            return 21;
        }
        if (perm.startsWith("delete")) {
            return 16;
        }
        if (perm.startsWith("sharefilters")) {
            return 22;
        }
        if (perm.startsWith("groupsubscriptions")) {
            return 24;
        }
        if (perm.startsWith("move")) {
            return 25;
        }
        if (perm.startsWith("setsecurity")) {
            return 26;
        }
        if (perm.startsWith("pickusers")) {
            return 27;
        }
        if (perm.startsWith("viewversioncontrol")) {
            return 29;
        }
        if (perm.startsWith("modifyreporter")) {
            return 30;
        }
        if (perm.startsWith("viewvotersandwatchers")) {
            return 31;
        }
        if (perm.startsWith("managewatcherlist")) {
            return 32;
        }
        if (perm.startsWith("bulkchange")) {
            return 33;
        }
        if (perm.startsWith("commenteditall")) {
            return 34;
        }
        if (perm.startsWith("commenteditown")) {
            return 35;
        }
        if (perm.startsWith("commentdeleteown")) {
            return 37;
        }
        if (perm.startsWith("commentdeleteall")) {
            return 36;
        }
        if (perm.startsWith("attachdeleteown")) {
            return 39;
        }
        if (perm.startsWith("attachdeleteall")) {
            return 38;
        }
        if (perm.startsWith("attach")) {
            return 19;
        }
        if (perm.startsWith("comment")) {
            return 15;
        }
        return -1;
    }

    public static String getShortName(int id) {
        switch (id) {
            case 0: {
                return "admin";
            }
            case 1: {
                return "use";
            }
            case 44: {
                return "sysadmin";
            }
            case 23: {
                return "project";
            }
            case 10: {
                return "browse";
            }
            case 11: {
                return "create";
            }
            case 12: {
                return "edit";
            }
            case 28: {
                return "scheduleissue";
            }
            case 13: {
                return "assign";
            }
            case 17: {
                return "assignable";
            }
            case 19: {
                return "attach";
            }
            case 14: {
                return "resolve";
            }
            case 18: {
                return "close";
            }
            case 15: {
                return "comment";
            }
            case 16: {
                return "delete";
            }
            case 20: {
                return "work";
            }
            case 43: {
                return "worklogdeleteall";
            }
            case 42: {
                return "worklogdeleteown";
            }
            case 41: {
                return "worklogeditall";
            }
            case 40: {
                return "worklogeditown";
            }
            case 21: {
                return "link";
            }
            case 22: {
                return "sharefilters";
            }
            case 24: {
                return "groupsubscriptions";
            }
            case 25: {
                return "move";
            }
            case 26: {
                return "setsecurity";
            }
            case 27: {
                return "pickusers";
            }
            case 29: {
                return "viewversioncontrol";
            }
            case 30: {
                return "modifyreporter";
            }
            case 31: {
                return "viewvotersandwatchers";
            }
            case 32: {
                return "managewatcherlist";
            }
            case 33: {
                return "bulkchange";
            }
            case 34: {
                return "commenteditall";
            }
            case 35: {
                return "commenteditown";
            }
            case 36: {
                return "commentdeleteall";
            }
            case 37: {
                return "commentdeleteown";
            }
            case 38: {
                return "attachdeleteall";
            }
            case 39: {
                return "attachdeleteown";
            }
        }
        return "";
    }

    public static String getDescription(int permType) {
        switch (permType) {
            case 0: {
                return Permissions.getText("admin.permissions.descriptions.ADMINISTER");
            }
            case 1: {
                return Permissions.getText("admin.permissions.descriptions.USE");
            }
            case 44: {
                return Permissions.getText("admin.permissions.descriptions.SYS_ADMIN");
            }
            case 23: {
                return Permissions.getText("admin.permissions.descriptions.PROJECT_ADMIN");
            }
            case 10: {
                return Permissions.getText("admin.permissions.descriptions.BROWSE");
            }
            case 11: {
                return Permissions.getText("admin.permissions.descriptions.CREATE_ISSUE");
            }
            case 12: {
                return Permissions.getText("admin.permissions.descriptions.EDIT_ISSUE");
            }
            case 28: {
                return Permissions.getText("admin.permissions.descriptions.SCHEDULE_ISSUE");
            }
            case 13: {
                return Permissions.getText("admin.permissions.descriptions.ASSIGN_ISSUE");
            }
            case 17: {
                return Permissions.getText("admin.permissions.descriptions.ASSIGNABLE_USER");
            }
            case 19: {
                return Permissions.getText("admin.permissions.descriptions.CREATE_ATTACHMENT");
            }
            case 14: {
                return Permissions.getText("admin.permissions.descriptions.RESOLVE_ISSUE");
            }
            case 18: {
                return Permissions.getText("admin.permissions.descriptions.CLOSE_ISSUE");
            }
            case 15: {
                return Permissions.getText("admin.permissions.descriptions.COMMENT_ISSUE");
            }
            case 16: {
                return Permissions.getText("admin.permissions.descriptions.DELETE_ISSUE");
            }
            case 20: {
                return Permissions.getText("admin.permissions.descriptions.WORK_ISSUE");
            }
            case 43: {
                return Permissions.getText("admin.permissions.descriptions.WORKLOG_DELETE_ALL");
            }
            case 42: {
                return Permissions.getText("admin.permissions.descriptions.WORKLOG_DELETE_OWN");
            }
            case 41: {
                return Permissions.getText("admin.permissions.descriptions.WORKLOG_EDIT_ALL");
            }
            case 40: {
                return Permissions.getText("admin.permissions.descriptions.WORKLOG_EDIT_OWN");
            }
            case 21: {
                return Permissions.getText("admin.permissions.descriptions.LINK_ISSUE");
            }
            case 22: {
                return Permissions.getText("admin.permissions.descriptions.CREATE_SHARED_OBJECTS");
            }
            case 24: {
                return Permissions.getText("admin.permissions.descriptions.MANAGE_GROUP_FILTER_SUBSCRIPTIONS");
            }
            case 25: {
                return Permissions.getText("admin.permissions.descriptions.MOVE_ISSUE");
            }
            case 26: {
                return Permissions.getText("admin.permissions.descriptions.SET_ISSUE_SECURITY");
            }
            case 27: {
                return Permissions.getText("admin.permissions.descriptions.USER_PICKER");
            }
            case 29: {
                return Permissions.getText("admin.permissions.descriptions.VIEW_VERSION_CONTROL");
            }
            case 30: {
                return Permissions.getText("admin.permissions.descriptions.MODIFY_REPORTER");
            }
            case 31: {
                return Permissions.getText("admin.permissions.descriptions.VIEW_VOTERS_AND_WATCHERS");
            }
            case 32: {
                return Permissions.getText("admin.permissions.descriptions.MANAGE_WATCHER_LIST");
            }
            case 33: {
                return Permissions.getText("admin.permissions.descriptions.BULK_CHANGE");
            }
            case 34: {
                return Permissions.getText("admin.permissions.descriptions.COMMENT_EDIT_ALL");
            }
            case 35: {
                return Permissions.getText("admin.permissions.descriptions.COMMENT_EDIT_OWN");
            }
            case 36: {
                return Permissions.getText("admin.permissions.descriptions.COMMENT_DELETE_ALL");
            }
            case 37: {
                return Permissions.getText("admin.permissions.descriptions.COMMENT_DELETE_OWN");
            }
            case 38: {
                return Permissions.getText("admin.permissions.descriptions.ATTACHMENT_DELETE_ALL");
            }
            case 39: {
                return Permissions.getText("admin.permissions.descriptions.ATTACHMENT_DELETE_OWN");
            }
        }
        return "";
    }

    public static boolean isGlobalPermission(int permType) {
        switch (permType) {
            case 44: {
                return true;
            }
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
            case 27: {
                return true;
            }
            case 22: {
                return true;
            }
            case 24: {
                return true;
            }
            case 33: {
                return true;
            }
        }
        return false;
    }

    private static String getText(String key) {
        return ComponentAccessor.getJiraAuthenticationContext().getI18nHelper().getText(key);
    }
}

