/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.user.provider.crowd;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.ImmutableGroup;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.google.common.collect.Lists;
import com.opensymphony.user.provider.AccessProvider;
import com.opensymphony.user.provider.crowd.EmbeddedCrowdAbstractProvider;
import java.util.Collections;
import java.util.List;

public class EmbeddedCrowdAccessProvider
extends EmbeddedCrowdAbstractProvider
implements AccessProvider {
    @Override
    public boolean addToGroup(String userName, String groupName) {
        CrowdService crowdService = this.getCrowdService();
        try {
            User user = crowdService.getUser(userName);
            Group group = crowdService.getGroup(groupName);
            if (user != null && group != null) {
                if (!crowdService.isUserMemberOfGroup(user, group)) {
                    crowdService.addUserToGroup(user, group);
                }
                return true;
            }
            this.logger.error("Could not add user:" + userName + " to group:" + groupName + " as user or group was not found");
            return false;
        }
        catch (Exception e) {
            this.logger.error("Could not add user:" + userName + " to group:" + groupName, (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean create(String name) {
        try {
            ImmutableGroup group = new ImmutableGroup(name);
            this.getCrowdService().addGroup((Group)group);
            return true;
        }
        catch (Exception e) {
            this.logger.error("Could not create group: " + name, (Throwable)e);
            return false;
        }
    }

    @Override
    public void flushCaches() {
    }

    @Override
    public boolean handles(String name) {
        CrowdService crowdService = this.getCrowdService();
        try {
            if (crowdService.getGroup(name) != null) {
                return true;
            }
            return crowdService.getUser(name) != null;
        }
        catch (Exception e) {
            this.logger.error("Could not determine if we handle: " + name, (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean inGroup(String userName, String groupName) {
        CrowdService crowdService = this.getCrowdService();
        try {
            User user = crowdService.getUser(userName);
            Group group = crowdService.getGroup(groupName);
            if (user != null && group != null) {
                return crowdService.isUserMemberOfGroup(user, group);
            }
            return false;
        }
        catch (Exception e) {
            this.logger.error("Could not determine if user: " + userName + " is in group: " + groupName, (Throwable)e);
            return false;
        }
    }

    @Override
    public List<String> list() {
        Iterable groupNames = this.getCrowdService().search((Query)QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).returningAtMost(-1));
        return Collections.unmodifiableList(Lists.newArrayList((Iterable)groupNames));
    }

    @Override
    public List<String> listGroupsContainingUser(String userName) {
        Iterable groupNames = this.getCrowdService().search((Query)QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(userName).returningAtMost(-1));
        return Collections.unmodifiableList(Lists.newArrayList((Iterable)groupNames));
    }

    @Override
    public List<String> listUsersInGroup(String groupName) {
        Iterable userNames = this.getCrowdService().search((Query)QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(groupName).returningAtMost(-1));
        return Collections.unmodifiableList(Lists.newArrayList((Iterable)userNames));
    }

    @Override
    public boolean remove(String name) {
        CrowdService crowdService = this.getCrowdService();
        try {
            Group crowdGroup = crowdService.getGroup(name);
            if (crowdGroup != null) {
                crowdService.removeGroup(crowdGroup);
                return true;
            }
            return true;
        }
        catch (Exception e) {
            this.logger.warn("Could not remove group: " + name, (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean removeFromGroup(String userName, String groupName) {
        CrowdService crowdService = this.getCrowdService();
        try {
            User user = crowdService.getUser(userName);
            Group group = crowdService.getGroup(groupName);
            if (user != null && group != null) {
                crowdService.removeUserFromGroup(user, group);
                return true;
            }
            this.logger.warn("Could not remove user: " + userName + " from group: " + groupName + " as either user or group was not found");
            return false;
        }
        catch (Exception e) {
            this.logger.warn("Could not remove user: " + userName + " from group: " + groupName, (Throwable)e);
            return false;
        }
    }
}

