/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.user;

import com.opensymphony.user.DuplicateEntityException;
import com.opensymphony.user.Entity;
import com.opensymphony.user.EntityNotFoundException;
import com.opensymphony.user.Group;
import com.opensymphony.user.ImmutableException;
import com.opensymphony.user.ProviderAccessor;
import com.opensymphony.user.User;
import com.opensymphony.user.UserManagerImplementationException;
import com.opensymphony.user.provider.AccessProvider;
import com.opensymphony.user.provider.CredentialsProvider;
import com.opensymphony.user.provider.ProfileProvider;
import com.opensymphony.user.provider.UserProvider;
import com.opensymphony.user.provider.crowd.EmbeddedCrowdAccessProvider;
import com.opensymphony.user.provider.crowd.EmbeddedCrowdCredentialsProvider;
import com.opensymphony.user.provider.crowd.EmbeddedCrowdProfileProvider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class UserManager
implements Serializable {
    private static UserManager instance;
    private static final Logger logger;
    private final Accessor accessor = new Accessor();
    private final List<AccessProvider> accessProviders;
    private final List<CredentialsProvider> credentialsProviders;
    private final List<ProfileProvider> profileProviders;
    private final AccessProvider accessProvider = new EmbeddedCrowdAccessProvider();
    private final CredentialsProvider credentialsProvider = new EmbeddedCrowdCredentialsProvider();
    private final ProfileProvider profileProvider = new EmbeddedCrowdProfileProvider();

    public UserManager() {
        this.accessProviders = Collections.singletonList(this.accessProvider);
        this.credentialsProviders = Collections.singletonList(this.credentialsProvider);
        this.profileProviders = Collections.singletonList(this.profileProvider);
    }

    public static void setInstance(UserManager userManager) {
        instance = userManager;
    }

    public static UserManager getInstance() {
        try {
            if (instance == null) {
                instance = new UserManager();
            }
        }
        catch (UserManagerImplementationException e) {
            logger.error("Unable to load configuration", (Throwable)e);
        }
        catch (RuntimeException e) {
            logger.error("unexpected runtime exception during initialization", (Throwable)e);
        }
        return instance;
    }

    public Accessor getAccessor() {
        return this.accessor;
    }

    public Collection<AccessProvider> getAccessProviders() {
        return this.accessProviders;
    }

    public Collection<CredentialsProvider> getCredentialsProviders() {
        return this.credentialsProviders;
    }

    public Collection<ProfileProvider> getProfileProviders() {
        return this.profileProviders;
    }

    public List<Group> getGroups() {
        return this.getEntities(Type.GROUP);
    }

    public List<User> getUsers() {
        return this.getEntities(Type.USER);
    }

    public Group getGroup(String name) throws EntityNotFoundException {
        return (Group)this.getEntity(name, Type.GROUP);
    }

    public User getUser(String name) throws EntityNotFoundException {
        return (User)this.getEntity(name, Type.USER);
    }

    public Group createGroup(String name) throws DuplicateEntityException, ImmutableException {
        return (Group)this.createEntity(name, Type.GROUP);
    }

    public User createUser(String name) throws DuplicateEntityException, ImmutableException {
        return (User)this.createEntity(name, Type.USER);
    }

    public void flushCaches() {
        this.accessProvider.flushCaches();
        this.credentialsProvider.flushCaches();
        this.profileProvider.flushCaches();
    }

    private <T extends Entity> List<T> getEntities(Type type) {
        ArrayList<T> result = new ArrayList<T>();
        List<UserProvider> toCheck = type == Type.GROUP ? this.accessProviders : this.credentialsProviders;
        for (UserProvider provider : toCheck) {
            List<String> entities = provider.list();
            if (entities == null) continue;
            for (String name : entities) {
                result.add(this.buildEntity(name, type));
            }
        }
        return result;
    }

    private <T extends Entity> T getEntity(String name, Type type) throws EntityNotFoundException {
        if (this.getProvider(name, type == Type.USER ? this.credentialsProviders : this.accessProviders) == null) {
            throw new EntityNotFoundException("No " + (type == Type.USER ? "user '" : "group '") + name + "' found");
        }
        return this.buildEntity(name, type);
    }

    <U extends UserProvider> U getProvider(String name, List<U> providers) {
        for (UserProvider provider : providers) {
            if (!provider.handles(name)) continue;
            return (U)provider;
        }
        if (providers == this.profileProviders) {
            for (UserProvider provider : providers) {
                if (!provider.create(name)) continue;
                return (U)provider;
            }
        }
        return null;
    }

    private <T extends Entity> T buildEntity(String name, Type type) {
        return type.create(name, this.accessor);
    }

    private <T extends Entity> T createEntity(String name, Type type) throws DuplicateEntityException, ImmutableException {
        List<UserProvider> providerList;
        List<UserProvider> list = providerList = type == Type.GROUP ? this.accessProviders : this.credentialsProviders;
        if (this.getProvider(name, providerList) != null) {
            throw new DuplicateEntityException((type == Type.USER ? "user " : "group ") + name + " already exists");
        }
        Iterator<UserProvider> i$ = providerList.iterator();
        while (i$.hasNext()) {
            UserProvider provider;
            Class toCheck = type == Type.GROUP ? AccessProvider.class : CredentialsProvider.class;
            if (!toCheck.isAssignableFrom((provider = i$.next()).getClass()) || !provider.create(name)) continue;
            return this.buildEntity(name, type);
        }
        throw new ImmutableException("No provider successfully created entity " + name);
    }

    static {
        logger = LoggerFactory.getLogger(UserManager.class);
    }

    public class Accessor
    implements ProviderAccessor {
        @Override
        public AccessProvider getAccessProvider(String name) {
            return UserManager.this.accessProvider;
        }

        @Override
        public CredentialsProvider getCredentialsProvider(String name) {
            return UserManager.this.credentialsProvider;
        }

        @Override
        public ProfileProvider getProfileProvider(String name) {
            return UserManager.this.profileProvider;
        }

        @Override
        public UserManager getUserManager() {
            return UserManager.this;
        }
    }

    static enum Type {
        USER{

            User create(String name, Accessor accessor) {
                return new User(name, accessor);
            }
        }
        ,
        GROUP{

            Group create(String name, Accessor accessor) {
                return new Group(name, accessor);
            }
        };


        abstract <T extends Entity> T create(String var1, Accessor var2);
    }
}

