/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.user;

import com.atlassian.crowd.embedded.api.UserComparator;
import com.opensymphony.user.Entity;
import com.opensymphony.user.EntityNotFoundException;
import com.opensymphony.user.Group;
import com.opensymphony.user.ImmutableException;
import com.opensymphony.user.ProviderAccessor;
import com.opensymphony.user.UserManager;
import com.opensymphony.user.provider.CredentialsProvider;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

@Deprecated
public class User
extends Entity
implements com.atlassian.crowd.embedded.api.User {
    private boolean active;
    private String emailAddress;
    private String displayName;
    private long directoryId;

    public User(com.atlassian.crowd.embedded.api.User crowdUser) {
        super(crowdUser.getName(), UserManager.getInstance().getAccessor());
        this.accessor = new Accessor();
        this.accessor.setName(crowdUser.getName());
        this.accessor.setMutable(true);
        this.directoryId = crowdUser.getDirectoryId();
        this.active = crowdUser.isActive();
        this.emailAddress = crowdUser.getEmailAddress();
        this.displayName = crowdUser.getDisplayName();
    }

    public User(String name, ProviderAccessor providerAccessor) {
        super(name, providerAccessor);
        this.accessor = new Accessor();
        com.atlassian.crowd.embedded.api.User crowdUser = this.getCrowdService().getUser(name);
        if (crowdUser != null) {
            this.accessor.setName(crowdUser.getName());
            this.accessor.setMutable(true);
            this.directoryId = crowdUser.getDirectoryId();
            this.active = crowdUser.isActive();
            this.emailAddress = crowdUser.getEmailAddress();
            this.displayName = crowdUser.getDisplayName();
        } else {
            this.accessor.setMutable(true);
            this.active = true;
        }
    }

    public void setEmail(String email) {
        this.emailAddress = email;
        this.update();
    }

    public String getEmail() {
        return this.emailAddress;
    }

    public void setFullName(String fullName) {
        this.displayName = fullName;
        this.update();
    }

    public String getFullName() {
        return this.displayName;
    }

    public List<String> getGroups() {
        if (this.getAccessProvider() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.getAccessProvider().listGroupsContainingUser(this.getName()));
    }

    public void setPassword(String password) throws ImmutableException {
        if (this.mutable && this.getCredentialsProvider().changePassword(this.name, password)) {
            return;
        }
        throw new ImmutableException();
    }

    public boolean addToGroup(Group group) {
        if (group == null) {
            return false;
        }
        return group.getAccessProvider().addToGroup(this.getName(), group.getName());
    }

    public boolean authenticate(String password) {
        if (password == null) {
            return false;
        }
        return this.getCredentialsProvider().authenticate(this.name, password);
    }

    public boolean inGroup(Group group) {
        if (group == null) {
            return false;
        }
        return group.getAccessProvider().inGroup(this.getName(), group.getName());
    }

    public boolean inGroup(String groupName) {
        if (groupName == null) {
            return false;
        }
        try {
            return this.inGroup(this.getUserManager().getGroup(groupName));
        }
        catch (EntityNotFoundException e) {
            return false;
        }
    }

    @Override
    public void remove() throws ImmutableException {
        CredentialsProvider credentialsProvider = this.getCredentialsProvider();
        if (!this.mutable) {
            throw new ImmutableException("User is not mutable");
        }
        if (credentialsProvider == null) {
            throw new ImmutableException("No credentials provider for user");
        }
        if (!credentialsProvider.remove(this.name)) {
            throw new ImmutableException("Credentials provider failed to remove user");
        }
    }

    public boolean removeFromGroup(Group group) {
        if (group == null) {
            return false;
        }
        return group.getAccessProvider().removeFromGroup(this.getName(), group.getName());
    }

    @Override
    public void store() throws ImmutableException {
        super.store();
        this.update();
    }

    protected void update() {
        this.getCrowdService().updateUser((com.atlassian.crowd.embedded.api.User)this);
    }

    public long getDirectoryId() {
        return this.directoryId;
    }

    public boolean isActive() {
        return this.active;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof com.atlassian.crowd.embedded.api.User && UserComparator.equal((com.atlassian.crowd.embedded.api.User)this, (com.atlassian.crowd.embedded.api.User)((com.atlassian.crowd.embedded.api.User)o));
    }

    @Override
    public int hashCode() {
        return UserComparator.hashCode((com.atlassian.crowd.embedded.api.User)this);
    }

    public int compareTo(com.atlassian.crowd.embedded.api.User other) {
        return UserComparator.compareTo((com.atlassian.crowd.embedded.api.User)this, (com.atlassian.crowd.embedded.api.User)other);
    }

    public final class Accessor
    extends Entity.Accessor
    implements Serializable {
        public Accessor() {
            super(User.this);
        }

        public User getUser() {
            return (User)this.getEntity();
        }
    }
}

