/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.group;

import com.atlassian.core.util.collection.EasyList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GroupRemoveUserMapper {
    private final List defaultGroupNames;
    private final Map groupsToRemoveByUserName;

    public GroupRemoveUserMapper() {
        this(Collections.EMPTY_LIST);
    }

    public GroupRemoveUserMapper(List defaultGroupNames) {
        if (defaultGroupNames == null) {
            throw new IllegalArgumentException("defaultGroupNames cannot be null");
        }
        this.defaultGroupNames = defaultGroupNames;
        this.groupsToRemoveByUserName = new HashMap();
    }

    public GroupRemoveUserMapper register(String userName) {
        if (this.groupsToRemoveByUserName.get(userName) == null) {
            this.groupsToRemoveByUserName.put(userName, new HashSet());
        }
        return this;
    }

    public GroupRemoveUserMapper register(String userName, String groupName) {
        return this.register(userName, EasyList.build((Object)groupName));
    }

    public GroupRemoveUserMapper register(String userName, Collection groupNames) {
        if (groupNames != null && !groupNames.isEmpty()) {
            if (this.groupsToRemoveByUserName.get(userName) == null) {
                this.groupsToRemoveByUserName.put(userName, new HashSet());
            }
            HashSet groups = (HashSet)this.groupsToRemoveByUserName.get(userName);
            groups.addAll(groupNames);
        }
        return this;
    }

    public boolean isRemoveFromAllSelected(String userName) {
        Set groups = (Set)this.groupsToRemoveByUserName.get(userName);
        return groups != null && groups.isEmpty();
    }

    public Iterator getGroupsIterator(String userName) {
        return this.getGroups(userName).iterator();
    }

    public Collection getGroups(String userName) {
        Collection groups = this.isRemoveFromAllSelected(userName) ? Collections.unmodifiableList(this.defaultGroupNames) : Collections.unmodifiableSet((Set)this.groupsToRemoveByUserName.get(userName));
        if (groups == null) {
            return Collections.EMPTY_LIST;
        }
        return groups;
    }

    public Iterator userIterator() {
        return this.groupsToRemoveByUserName.keySet().iterator();
    }

    public List getDefaultGroupNames() {
        return Collections.unmodifiableList(this.defaultGroupNames);
    }
}

