/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.avatar;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarSize;
import com.atlassian.jira.avatar.Selection;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.util.Consumer;
import com.atlassian.jira.util.NotNull;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public interface AvatarManager {
    public static final AvatarSize LARGE = new AvatarSize(48, "");
    public static final AvatarSize SMALL = new AvatarSize(16, "small_");
    public static final String AVATAR_IMAGE_FORMAT = "PNG";
    public static final String USER_AVATAR_ID_KEY = "user.avatar.id";

    public Avatar getById(Long var1) throws DataAccessException;

    public boolean delete(Long var1) throws DataAccessException;

    public boolean delete(Long var1, boolean var2);

    public void update(Avatar var1) throws DataAccessException;

    @NotNull
    public Avatar create(Avatar var1) throws DataAccessException;

    @NotNull
    public Avatar create(Avatar var1, InputStream var2, Selection var3) throws DataAccessException, IOException;

    @NotNull
    public List<Avatar> getAllSystemAvatars(Avatar.Type var1) throws DataAccessException;

    @NotNull
    public List<Avatar> getCustomAvatarsForOwner(Avatar.Type var1, String var2) throws DataAccessException;

    public boolean isAvatarOwner(Avatar var1, String var2);

    public void readLargeAvatarData(Avatar var1, Consumer<InputStream> var2) throws IOException;

    public void readSmallAvatarData(Avatar var1, Consumer<InputStream> var2) throws IOException;

    @NotNull
    public File getAvatarBaseDirectory();

    @NotNull
    public Long getDefaultAvatarId(Avatar.Type var1);

    public boolean hasPermissionToView(com.opensymphony.user.User var1, Avatar.Type var2, String var3);

    public boolean hasPermissionToView(User var1, Avatar.Type var2, String var3);

    public boolean hasPermissionToEdit(com.opensymphony.user.User var1, Avatar.Type var2, String var3);

    public boolean hasPermissionToEdit(User var1, Avatar.Type var2, String var3);

    public boolean isUserAvatarsEnabled();
}

