/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing.type;

import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.search.ProjectShareTypeSearchParameter;
import com.atlassian.jira.sharing.type.ShareType;
import com.atlassian.jira.util.dbc.Assertions;

public class ProjectSharePermission {
    private static final char ROLE_SEPARATOR = ':';
    private final Long projectId;
    private final Long roleId;

    public ProjectSharePermission(SharePermission permission) {
        Assertions.notNull("permissions", permission);
        Assertions.equals("permission type", ShareType.Name.PROJECT, permission.getType());
        this.projectId = permission.getParam1() == null ? null : new Long(permission.getParam1());
        this.roleId = permission.getParam2() == null ? null : new Long(permission.getParam2());
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public Long getRoleId() {
        return this.roleId;
    }

    public boolean hasRole() {
        return this.roleId != null;
    }

    public ProjectShareTypeSearchParameter getSearchParameter() {
        return new ProjectShareTypeSearchParameter(this.getProjectId(), this.getRoleId());
    }

    String getIndexValue() {
        return ProjectSharePermission.indexValue(this.projectId, this.roleId);
    }

    static String indexValue(Long projectId, Long roleId) {
        StringBuilder buffer = new StringBuilder();
        if (projectId != null) {
            buffer.append(projectId);
        }
        if (roleId != null) {
            buffer.append(':');
            buffer.append(roleId);
        }
        return buffer.toString();
    }

    static String searchAllRolesValue(Long projectId) {
        Assertions.notNull("projectId", projectId);
        return projectId.toString() + ":";
    }
}

