/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.request;

import com.atlassian.jira.search.annotations.ExperimentalSearchApi;
import com.google.common.base.Preconditions;
import java.util.Objects;

@ExperimentalSearchApi
public class PageRequest {
    private final int limit;
    private final int start;

    public PageRequest(int start, int limit) {
        Preconditions.checkArgument((start >= 0 ? 1 : 0) != 0, (Object)"start must be >= 0");
        Preconditions.checkArgument((limit >= 0 ? 1 : 0) != 0, (Object)"limit must be >= 0");
        this.limit = limit;
        this.start = start;
    }

    public static PageRequest of(int start, int limit) {
        return new PageRequest(start, limit);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PageRequest that = (PageRequest)o;
        return this.limit == that.limit && this.start == that.start;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getStart() {
        return this.start;
    }

    public int hashCode() {
        return Objects.hash(this.limit, this.start);
    }
}

