/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.query;

import com.atlassian.jira.search.Query;
import com.atlassian.jira.search.annotations.ExperimentalSearchApi;
import com.atlassian.jira.search.query.ChildQuery;
import java.util.Objects;

@ExperimentalSearchApi
public final class DefaultChildQuery
implements ChildQuery {
    private final String childDocumentType;
    private final Query childQuery;
    private final ChildQuery.ScoreMode scoreMode;

    public DefaultChildQuery(String childDocumentType, Query childQuery, ChildQuery.ScoreMode scoreMode) {
        this.childDocumentType = Objects.requireNonNull(childDocumentType, "childDocumentType");
        this.childQuery = Objects.requireNonNull(childQuery, "childQuery");
        this.scoreMode = scoreMode != null ? scoreMode : ChildQuery.ScoreMode.NONE;
    }

    public DefaultChildQuery(String childDocumentType, Query childQuery) {
        this(childDocumentType, childQuery, ChildQuery.ScoreMode.NONE);
    }

    @Override
    public String childDocumentType() {
        return this.childDocumentType;
    }

    @Override
    public Query childQuery() {
        return this.childQuery;
    }

    @Override
    public ChildQuery.ScoreMode scoreMode() {
        return this.scoreMode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DefaultChildQuery that = (DefaultChildQuery)obj;
        return Objects.equals(this.childDocumentType, that.childDocumentType) && Objects.equals(this.childQuery, that.childQuery) && Objects.equals((Object)this.scoreMode, (Object)that.scoreMode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.childDocumentType, this.childQuery, this.scoreMode});
    }

    public String toString() {
        return "DefaultChildQuery[childDocumentType=" + this.childDocumentType + ", childQuery=" + this.childDocumentType + ", scoreMode=" + String.valueOf((Object)this.scoreMode) + "]";
    }
}

