/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.jql;

import com.atlassian.jira.issue.comparator.VersionComparator;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.resolver.VersionIndexInfoResolver;
import com.atlassian.jira.jql.resolver.VersionResolver;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.search.Query;
import com.atlassian.jira.search.annotations.ExperimentalSearchApi;
import com.atlassian.jira.search.jql.ClauseQueryMapper;
import com.atlassian.jira.search.jql.EqualityQueryFactory;
import com.atlassian.jira.search.jql.GenericClauseQueryMapper;
import com.atlassian.jira.search.jql.OperatorSpecificQueryFactory;
import com.atlassian.jira.search.jql.VersionLikeQueryFactory;
import com.atlassian.jira.search.jql.VersionSpecificRelationalOperatorQueryFactory;
import com.atlassian.query.clause.TerminalClause;
import java.util.List;
import java.util.Objects;

@ExperimentalSearchApi
public class VersionCustomFieldClauseQueryMapper
implements ClauseQueryMapper {
    private final ClauseQueryMapper delegate;

    public VersionCustomFieldClauseQueryMapper(String documentFieldName, VersionResolver versionResolver, JqlOperandResolver operandResolver) {
        Objects.requireNonNull(documentFieldName);
        Objects.requireNonNull(versionResolver);
        Objects.requireNonNull(operandResolver);
        VersionIndexInfoResolver versionIndexInfoResolver = new VersionIndexInfoResolver(versionResolver);
        VersionIndexInfoResolver wildcardVersionIndexResolver = new VersionIndexInfoResolver(versionResolver, versionResolver::getIdsFromNameWildcard);
        List<OperatorSpecificQueryFactory> factories = List.of(new EqualityQueryFactory<Version>(versionIndexInfoResolver), new VersionSpecificRelationalOperatorQueryFactory(VersionComparator.COMPARATOR, versionResolver, versionIndexInfoResolver), new VersionLikeQueryFactory(wildcardVersionIndexResolver));
        this.delegate = new GenericClauseQueryMapper(documentFieldName, factories, operandResolver);
    }

    @Override
    public Query map(QueryCreationContext queryCreationContext, TerminalClause terminalClause) {
        return this.delegate.map(queryCreationContext, terminalClause);
    }
}

