/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.jql;

import com.atlassian.jira.issue.customfields.converters.DoubleConverter;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.search.Query;
import com.atlassian.jira.search.annotations.ExperimentalSearchApi;
import com.atlassian.jira.search.jql.ClauseQueryMapper;
import com.atlassian.jira.search.jql.GenericClauseQueryMapper;
import com.atlassian.jira.search.jql.NumberEqualityQueryFactory;
import com.atlassian.jira.search.jql.NumberRelationalQueryFactory;
import com.atlassian.jira.search.jql.OperatorSpecificQueryFactory;
import com.atlassian.query.clause.TerminalClause;
import java.util.ArrayList;
import java.util.Objects;

@ExperimentalSearchApi
public class NumberCustomFieldClauseQueryMapper
implements ClauseQueryMapper {
    private final ClauseQueryMapper delegate;

    public NumberCustomFieldClauseQueryMapper(String documentFieldName, JqlOperandResolver operandResolver, DoubleConverter doubleConverter, boolean supportsRelational) {
        Objects.requireNonNull(documentFieldName);
        Objects.requireNonNull(operandResolver);
        Objects.requireNonNull(doubleConverter);
        ArrayList<OperatorSpecificQueryFactory> operatorFactories = new ArrayList<OperatorSpecificQueryFactory>();
        operatorFactories.add(new NumberEqualityQueryFactory(doubleConverter));
        if (supportsRelational) {
            operatorFactories.add(new NumberRelationalQueryFactory(doubleConverter));
        }
        this.delegate = new GenericClauseQueryMapper(documentFieldName, operatorFactories, operandResolver);
    }

    @Override
    public Query map(QueryCreationContext queryCreationContext, TerminalClause terminalClause) {
        return this.delegate.map(queryCreationContext, terminalClause);
    }
}

