/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.jql;

import com.atlassian.jira.datetime.LocalDate;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.util.JqlLocalDateSupport;
import com.atlassian.jira.search.Query;
import com.atlassian.jira.search.annotations.ExperimentalSearchSpi;
import com.atlassian.jira.search.jql.OperatorSpecificQueryFactory;
import com.atlassian.jira.search.jql.TermQueryFactory;
import com.atlassian.jira.search.query.BooleanQuery;
import com.atlassian.jira.search.query.DefaultBooleanQuery;
import com.atlassian.jira.search.query.DefaultLongQuery;
import com.atlassian.jira.search.query.DefaultLongRangeQuery;
import com.atlassian.jira.search.query.DefaultMatchNoDocsQuery;
import com.atlassian.query.operator.Operator;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExperimentalSearchSpi
public class LocalDateEqualityQueryFactory
implements OperatorSpecificQueryFactory {
    private static final Logger log = LoggerFactory.getLogger(LocalDateEqualityQueryFactory.class);
    private final JqlLocalDateSupport jqlLocalDateSupport;

    public LocalDateEqualityQueryFactory(JqlLocalDateSupport jqlLocalDateSupport) {
        this.jqlLocalDateSupport = Objects.requireNonNull(jqlLocalDateSupport);
    }

    @Override
    public Query createQueryForSingleValue(String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        if (operator != Operator.EQUALS && operator != Operator.NOT_EQUALS) {
            log.debug("Creating an equality query for a single value for date field '{}' using unsupported operator: '{}', returning a false result (no issues). Supported operators are: '{}' and '{}'", new Object[]{fieldName, operator, Operator.EQUALS, Operator.NOT_EQUALS});
            return DefaultMatchNoDocsQuery.INSTANCE;
        }
        return this.createResult(fieldName, operator, rawValues);
    }

    @Override
    public Query createQueryForMultipleValues(String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        if (operator == Operator.IN || operator == Operator.NOT_IN) {
            return this.createResult(fieldName, operator, rawValues);
        }
        log.debug("Creating an equality query for multiple values for date field '{}' using unsupported operator: '{}', returning a false result (no issues). Supported operators are: '{}' and '{}'", new Object[]{fieldName, operator, Operator.IN, Operator.NOT_IN});
        return DefaultMatchNoDocsQuery.INSTANCE;
    }

    private Query createResult(String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        if (operator == Operator.IN || operator == Operator.EQUALS) {
            return this.handleIn(fieldName, this.jqlLocalDateSupport.getLocalDatesFromQueryLiterals(rawValues));
        }
        if (operator == Operator.NOT_IN || operator == Operator.NOT_EQUALS) {
            return this.handleNotIn(fieldName, this.jqlLocalDateSupport.getLocalDatesFromQueryLiterals(rawValues));
        }
        return DefaultMatchNoDocsQuery.INSTANCE;
    }

    @Override
    public Query createQueryForEmptyOperand(String fieldName, Operator operator) {
        if (operator == Operator.IS || operator == Operator.EQUALS) {
            return this.getIsEmptyQuery(fieldName);
        }
        if (operator == Operator.IS_NOT || operator == Operator.NOT_EQUALS) {
            return this.getIsNotEmptyQuery(fieldName);
        }
        log.debug("Creating an equality query for an empty value for date field '{}' using unsupported operator: '{}', returning a false result (no issues). Supported operators are: '{}','{}', '{}' and '{}'", new Object[]{fieldName, operator, Operator.IS, Operator.EQUALS, Operator.IS_NOT, Operator.NOT_EQUALS});
        return DefaultMatchNoDocsQuery.INSTANCE;
    }

    @Override
    public boolean handlesOperator(Operator operator) {
        return OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY.contains((Object)operator);
    }

    private Query handleEquals(String fieldName, LocalDate value) {
        return new DefaultLongQuery(fieldName, value.getEpochDays());
    }

    private Query handleNotEquals(String fieldName, LocalDate value) {
        DefaultBooleanQuery.Builder combined = new DefaultBooleanQuery.Builder();
        long indexedValue = value.getEpochDays();
        combined.add(new DefaultLongRangeQuery(fieldName, Long.MIN_VALUE, indexedValue - 1L), BooleanQuery.Occur.SHOULD);
        combined.add(new DefaultLongRangeQuery(fieldName, indexedValue + 1L, Long.MAX_VALUE), BooleanQuery.Occur.SHOULD);
        return combined.build();
    }

    private Query handleIn(String fieldName, List<LocalDate> values) {
        if (values.size() == 1) {
            LocalDate localDate = values.get(0);
            Query query = localDate == null ? this.getIsEmptyQuery(fieldName) : this.handleEquals(fieldName, localDate);
            return query;
        }
        DefaultBooleanQuery.Builder combined = new DefaultBooleanQuery.Builder();
        for (LocalDate value : values) {
            if (value == null) {
                combined.add(this.getIsEmptyQuery(fieldName), BooleanQuery.Occur.SHOULD);
                continue;
            }
            combined.add(this.handleEquals(fieldName, value), BooleanQuery.Occur.SHOULD);
        }
        return combined.build();
    }

    private Query handleNotIn(String fieldName, List<LocalDate> values) {
        if (values.size() == 1) {
            LocalDate date = values.get(0);
            Query query = date == null ? this.getIsNotEmptyQuery(fieldName) : this.handleNotEquals(fieldName, date);
            return query;
        }
        DefaultBooleanQuery.Builder combined = new DefaultBooleanQuery.Builder();
        for (LocalDate value : values) {
            if (value == null) {
                combined.add(this.getIsNotEmptyQuery(fieldName), BooleanQuery.Occur.SHOULD);
                continue;
            }
            combined.add(this.handleNotEquals(fieldName, value), BooleanQuery.Occur.MUST);
        }
        return combined.build();
    }

    private Query getIsEmptyQuery(String fieldName) {
        return TermQueryFactory.emptyQuery(fieldName);
    }

    private Query getIsNotEmptyQuery(String fieldName) {
        return TermQueryFactory.nonEmptyQuery(fieldName);
    }
}

