/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.jql;

import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.search.Query;
import com.atlassian.jira.search.annotations.ExperimentalSearchApi;
import com.atlassian.jira.search.jql.ClauseQueryMapper;
import com.atlassian.jira.search.jql.OperatorSpecificQueryFactory;
import com.atlassian.jira.search.query.DefaultMatchNoDocsQuery;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operator.Operator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExperimentalSearchApi
public class GenericClauseQueryMapper
implements ClauseQueryMapper {
    private static final Logger log = LoggerFactory.getLogger(GenericClauseQueryMapper.class);
    private final JqlOperandResolver operandResolver;
    private final List<OperatorSpecificQueryFactory> factories;
    private final String documentFieldName;

    public GenericClauseQueryMapper(String documentFieldName, List<OperatorSpecificQueryFactory> factories, JqlOperandResolver operandResolver) {
        this.documentFieldName = Objects.requireNonNull(documentFieldName);
        this.operandResolver = Objects.requireNonNull(operandResolver);
        this.factories = List.copyOf(factories);
    }

    @Override
    public Query map(QueryCreationContext queryCreationContext, TerminalClause terminalClause) {
        Operand operand = terminalClause.getOperand();
        Operator operator = terminalClause.getOperator();
        if (!this.operandResolver.isValidOperand(operand)) {
            log.debug("There is no OperandHandler registered to handle the operator '{}' for operand '{}'.", (Object)operator.getDisplayString(), (Object)operand.getDisplayString());
            return DefaultMatchNoDocsQuery.INSTANCE;
        }
        for (OperatorSpecificQueryFactory factory : this.factories) {
            if (!factory.handlesOperator(operator)) continue;
            if (this.operandResolver.isEmptyOperand(operand)) {
                return factory.createQueryForEmptyOperand(this.documentFieldName, operator);
            }
            if (this.operandResolver.isListOperand(operand)) {
                return factory.createQueryForMultipleValues(this.documentFieldName, operator, this.getRawValues(queryCreationContext, terminalClause));
            }
            return factory.createQueryForSingleValue(this.documentFieldName, operator, this.getRawValues(queryCreationContext, terminalClause));
        }
        log.debug("The '{}' clause does not support the {} operator.", (Object)terminalClause.getName(), (Object)operator.getDisplayString());
        return DefaultMatchNoDocsQuery.INSTANCE;
    }

    private List<QueryLiteral> getRawValues(QueryCreationContext queryCreationContext, TerminalClause clause) {
        return Optional.ofNullable(this.operandResolver.getValues(queryCreationContext, clause.getOperand(), clause)).orElse(List.of());
    }
}

