/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.jql;

import com.atlassian.jira.jql.resolver.IndexInfoResolver;
import com.atlassian.jira.search.Query;
import com.atlassian.jira.search.annotations.ExperimentalSearchApi;
import com.atlassian.jira.search.jql.AbstractEqualityQueryFactory;
import com.atlassian.jira.search.jql.TermQueryFactory;
import com.atlassian.jira.search.query.DefaultMatchNoDocsQuery;
import com.atlassian.query.operator.Operator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExperimentalSearchApi
public class EqualityQueryFactory<T>
extends AbstractEqualityQueryFactory<T> {
    private static final Logger log = LoggerFactory.getLogger(EqualityQueryFactory.class);

    public EqualityQueryFactory(IndexInfoResolver<T> tIndexInfoResolver) {
        super(tIndexInfoResolver);
    }

    @Override
    public Query createQueryForEmptyOperand(String fieldName, Operator operator) {
        if (operator == Operator.IS || operator == Operator.EQUALS) {
            return this.getIsEmptyQuery(fieldName);
        }
        if (operator == Operator.IS_NOT || operator == Operator.NOT_EQUALS) {
            return this.getIsNotEmptyQuery(fieldName);
        }
        log.debug("Cannot create a query for an empty operand using the operator '{}'", (Object)operator.getDisplayString());
        return DefaultMatchNoDocsQuery.INSTANCE;
    }

    @Override
    Query getIsEmptyQuery(String fieldName) {
        return TermQueryFactory.emptyQuery(fieldName);
    }

    @Override
    Query getIsNotEmptyQuery(String fieldName) {
        return TermQueryFactory.nonEmptyQuery(fieldName);
    }
}

