/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.jql;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.search.Query;
import com.atlassian.jira.search.SearchPlatform;
import com.atlassian.jira.search.annotations.DeprecatedBySearchApi;
import com.atlassian.jira.search.annotations.ExperimentalSearchApi;
import com.atlassian.jira.search.jql.ClauseQueryMapper;
import com.atlassian.jira.search.query.DefaultBooleanQuery;
import com.atlassian.jira.search.query.DefaultMatchNoDocsQuery;
import com.atlassian.jira.search.query.LuceneLegacyQuery;
import com.atlassian.query.clause.TerminalClause;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(since="10.4", forRemoval=true)
@DeprecatedBySearchApi
@ExperimentalSearchApi
public class ClauseQueryFactoryToMapperAdapter
implements ClauseQueryMapper {
    private static final Logger log = LoggerFactory.getLogger(ClauseQueryFactoryToMapperAdapter.class);
    private final ClauseQueryFactory clauseQueryFactory;
    private Boolean isOpenSearch;

    public ClauseQueryFactoryToMapperAdapter(ClauseQueryFactory clauseQueryFactory) {
        this.clauseQueryFactory = Objects.requireNonNull(clauseQueryFactory);
    }

    @Override
    public Query map(QueryCreationContext queryCreationContext, TerminalClause terminalClause) {
        if (this.isOpenSearch()) {
            log.warn("Missing clause query mapper for {}", (Object)terminalClause);
            return DefaultMatchNoDocsQuery.INSTANCE;
        }
        QueryFactoryResult factoryResult = this.clauseQueryFactory.getQuery(queryCreationContext, terminalClause);
        LuceneLegacyQuery luceneLegacyQuery = factoryResult::getLuceneQuery;
        return factoryResult.mustNotOccur() ? DefaultBooleanQuery.mustNot(luceneLegacyQuery) : luceneLegacyQuery;
    }

    private boolean isOpenSearch() {
        if (this.isOpenSearch == null) {
            ApplicationProperties applicationProperties = ComponentAccessor.getComponent(ApplicationProperties.class);
            SearchPlatform searchPlatform = SearchPlatform.fromString(applicationProperties.getDefaultString("search.platform"));
            this.isOpenSearch = searchPlatform == SearchPlatform.OPENSEARCH;
        }
        return this.isOpenSearch;
    }
}

