/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.jql;

import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.util.IndexValueConverter;
import com.atlassian.jira.search.Query;
import com.atlassian.jira.search.annotations.ExperimentalSearchApi;
import com.atlassian.jira.search.jql.AbstractActualValueOperatorQueryFactory;
import com.atlassian.jira.search.jql.OperatorSpecificQueryFactory;
import com.atlassian.jira.search.jql.RangeQueryFactory;
import com.atlassian.jira.search.query.BooleanQuery;
import com.atlassian.jira.search.query.DefaultBooleanQuery;
import com.atlassian.jira.search.query.DefaultMatchNoDocsQuery;
import com.atlassian.jira.search.query.DefaultTermQuery;
import com.atlassian.query.operator.Operator;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExperimentalSearchApi
public class ActualValueRelationalQueryFactory
extends AbstractActualValueOperatorQueryFactory
implements OperatorSpecificQueryFactory {
    private static final Logger log = LoggerFactory.getLogger(ActualValueRelationalQueryFactory.class);
    private static final RangeQueryFactory<String> RANGE_QUERY_FACTORY = RangeQueryFactory.stringRangeQueryFactory();
    private final String emptyIndexValue;

    public ActualValueRelationalQueryFactory(IndexValueConverter indexValueConverter) {
        super(indexValueConverter);
        this.emptyIndexValue = null;
    }

    public ActualValueRelationalQueryFactory(IndexValueConverter indexValueConverter, String emptyIndexValue) {
        super(indexValueConverter);
        this.emptyIndexValue = Objects.requireNonNull(emptyIndexValue);
    }

    @Override
    public Query createQueryForSingleValue(String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        if (!this.handlesOperator(operator)) {
            log.debug("ActualValueRelationalQueryFactory does not support operator '{}'.", (Object)operator.getDisplayString());
            return DefaultMatchNoDocsQuery.INSTANCE;
        }
        List<String> values = this.getIndexValues(rawValues);
        if (values.isEmpty()) {
            return DefaultMatchNoDocsQuery.INSTANCE;
        }
        String value = values.get(0);
        if (value == null) {
            log.debug("Relation operators do not support empty values");
            return DefaultMatchNoDocsQuery.INSTANCE;
        }
        Query query = RANGE_QUERY_FACTORY.get(operator, fieldName, value);
        if (this.emptyIndexValue != null) {
            DefaultBooleanQuery.Builder combined = new DefaultBooleanQuery.Builder();
            combined.add(query, BooleanQuery.Occur.MUST);
            combined.add(new DefaultTermQuery(fieldName, this.emptyIndexValue), BooleanQuery.Occur.MUST_NOT);
            query = combined.build();
        }
        return query;
    }

    @Override
    public Query createQueryForMultipleValues(String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        log.debug("Relation operators do not support multivalue operands");
        return DefaultMatchNoDocsQuery.INSTANCE;
    }

    @Override
    public Query createQueryForEmptyOperand(String fieldName, Operator operator) {
        log.debug("Relation operators do not support multivalue empty");
        return DefaultMatchNoDocsQuery.INSTANCE;
    }

    @Override
    public boolean handlesOperator(Operator operator) {
        return OperatorClasses.RELATIONAL_ONLY_OPERATORS.contains((Object)operator);
    }
}

