/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.jql;

import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.util.IndexValueConverter;
import com.atlassian.jira.search.annotations.ExperimentalSearchSpi;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ExperimentalSearchSpi
abstract class AbstractActualValueOperatorQueryFactory {
    private final IndexValueConverter indexValueConverter;

    protected AbstractActualValueOperatorQueryFactory(IndexValueConverter indexValueConverter) {
        this.indexValueConverter = Objects.requireNonNull(indexValueConverter);
    }

    List<String> getIndexValues(List<QueryLiteral> rawValues) {
        ArrayList values = Lists.newArrayListWithCapacity((int)rawValues.size());
        for (QueryLiteral rawValue : rawValues) {
            if (rawValue.isEmpty()) {
                values.add(null);
                continue;
            }
            String indexValue = this.indexValueConverter.convertToIndexValue(rawValue);
            if (indexValue == null) continue;
            values.add(indexValue);
        }
        return values;
    }
}

