/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.issue.index.indexers.impl;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.vdi.CustomFieldPrefetchedData;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.search.annotations.ExperimentalSearchApi;
import com.atlassian.jira.search.field.AbstractField;
import com.atlassian.jira.search.field.FieldValueCollector;
import com.atlassian.jira.search.field.KeywordField;
import com.atlassian.jira.search.issue.index.indexers.impl.BaseCustomFieldIndexer;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.Collection;

@ExperimentalSearchApi
public class VersionCustomFieldIndexer
extends BaseCustomFieldIndexer {
    private static KeywordField buildCustomField(CustomField customField) {
        return (KeywordField)((AbstractField.Builder)((AbstractField.Builder)((AbstractField.Builder)KeywordField.builder(customField.getId()).stored()).indexed()).docValues()).multiValued().build();
    }

    public VersionCustomFieldIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField) {
        super(fieldVisibilityManager, customField, VersionCustomFieldIndexer.buildCustomField(customField));
    }

    @Override
    public void indexFields(FieldValueCollector collector, Issue issue, CustomFieldPrefetchedData prefetchedData) {
        Object value = this.customField.getValue(issue);
        if (value instanceof Collection) {
            Collection versions = (Collection)value;
            for (Version version : versions) {
                this.indexField(collector, version.getId().toString(), issue);
            }
        }
    }

    @Override
    public boolean skipsIndexingNull() {
        return true;
    }
}

