/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.issue.index.indexers.impl;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.converters.UserConverter;
import com.atlassian.jira.issue.customfields.vdi.CustomFieldPrefetchedData;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.SecurityIndexingUtils;
import com.atlassian.jira.search.annotations.ExperimentalSearchApi;
import com.atlassian.jira.search.field.AbstractField;
import com.atlassian.jira.search.field.FieldValueCollector;
import com.atlassian.jira.search.field.KeywordField;
import com.atlassian.jira.search.issue.index.indexers.impl.BaseCustomFieldIndexer;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.FieldVisibilityManager;

@ExperimentalSearchApi
public class UserCustomFieldIndexer
extends BaseCustomFieldIndexer {
    private final UserConverter userConverter;

    private static KeywordField buildCustomField(CustomField customField) {
        return (KeywordField)((AbstractField.Builder)((AbstractField.Builder)((AbstractField.Builder)KeywordField.builder(customField.getId()).stored()).indexed()).docValues()).multiValued().build();
    }

    public UserCustomFieldIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField, UserConverter userConverter) {
        super(fieldVisibilityManager, customField, UserCustomFieldIndexer.buildCustomField(customField));
        this.userConverter = userConverter;
    }

    @Override
    public void indexFields(FieldValueCollector collector, Issue issue, CustomFieldPrefetchedData prefetchedData) {
        Object value = this.customField.getValue(issue);
        if (value instanceof ApplicationUser) {
            ApplicationUser user = (ApplicationUser)value;
            String userId = this.userConverter.getDbString(user);
            this.indexField(collector, userId, issue);
            SecurityIndexingUtils.indexPermissions(collector, issue, this.getId(), userId);
        }
    }

    @Override
    public boolean skipsIndexingNull() {
        return true;
    }
}

