/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.issue.index.indexers.impl;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.converters.DoubleConverter;
import com.atlassian.jira.issue.customfields.vdi.CustomFieldPrefetchedData;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.lucenelegacy.NumericUtils;
import com.atlassian.jira.search.Field;
import com.atlassian.jira.search.annotations.ExperimentalSearchApi;
import com.atlassian.jira.search.field.AbstractField;
import com.atlassian.jira.search.field.DoubleField;
import com.atlassian.jira.search.field.FieldValueCollector;
import com.atlassian.jira.search.field.KeywordField;
import com.atlassian.jira.search.issue.index.indexers.CustomFieldIndexer;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.Collection;
import java.util.List;

@ExperimentalSearchApi
public class NumberCustomFieldIndexer
implements CustomFieldIndexer {
    private final CustomField customField;
    protected final FieldVisibilityManager fieldVisibilityManager;
    private final KeywordField searchablePaddedStringField;
    private final KeywordField unsearchablePaddedStringField;
    private final DoubleField searchableDoubleField;
    private final KeywordField searchableSortedStringField;
    private final DoubleConverter doubleConverter;
    private final boolean skipsIndexingNull;

    public NumberCustomFieldIndexer(FieldVisibilityManager fieldVisibilityManager, DoubleConverter doubleConverter, CustomField customField, boolean skipsIndexingNull) {
        this.customField = customField;
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.doubleConverter = doubleConverter;
        this.skipsIndexingNull = skipsIndexingNull;
        this.searchablePaddedStringField = NumberCustomFieldIndexer.buildSearchablePaddedStringField(customField);
        this.unsearchablePaddedStringField = NumberCustomFieldIndexer.buildUnsearchablePaddedStringField(customField, this.searchablePaddedStringField);
        this.searchableDoubleField = NumberCustomFieldIndexer.buildDoubleField(customField);
        this.searchableSortedStringField = NumberCustomFieldIndexer.buildSortField(customField);
    }

    private static DoubleField buildDoubleField(CustomField customField) {
        return (DoubleField)DoubleField.builder(customField.getId()).docValues().build();
    }

    private static KeywordField buildSortField(CustomField customField) {
        return (KeywordField)((AbstractField.Builder)KeywordField.builder("sort_" + customField.getId()).indexed()).docValues().build();
    }

    private static KeywordField buildSearchablePaddedStringField(CustomField customField) {
        return (KeywordField)KeywordField.builder("string_" + customField.getId()).overrideLuceneName(customField.getId()).indexed().stored().build();
    }

    private static KeywordField buildUnsearchablePaddedStringField(CustomField customField, KeywordField searchableField) {
        return (KeywordField)((AbstractField.Builder)KeywordField.builder(searchableField.name() + "_unsearchable").stored()).overrideLuceneName(customField.getId()).retrievalName(searchableField.name()).build();
    }

    @Override
    public String getId() {
        return this.customField.getId();
    }

    @Override
    public boolean isFieldVisibleAndInScope(Issue issue) {
        return this.fieldVisibilityManager.isFieldVisible(this.getId(), issue) && this.customField.isRelevantForIssueContext(issue);
    }

    @Override
    public CustomField getCustomField() {
        return this.customField;
    }

    @Override
    public void indexFields(FieldValueCollector collector, Issue issue, CustomFieldPrefetchedData prefetchedData) {
        Double value = (Double)this.customField.getValue(issue);
        boolean isVisible = this.isFieldVisibleAndInScope(issue);
        if (value != null) {
            String valueAsPaddedString = this.doubleConverter.getStringForLucene(value);
            if (isVisible) {
                collector.add(this.searchablePaddedStringField, valueAsPaddedString);
                collector.add(this.searchableDoubleField, value);
                collector.add(this.searchableSortedStringField, NumericUtils.doubleToPrefixCoded((double)value));
            } else {
                collector.add(this.unsearchablePaddedStringField, valueAsPaddedString);
            }
        } else if (!this.skipsIndexingNull && this.isFieldVisibleAndInScope(issue)) {
            collector.add(this.searchableSortedStringField, NumericUtils.doubleToPrefixCoded((double)Double.MAX_VALUE));
        }
    }

    @Override
    public Collection<Field> getFields() {
        return List.of(this.searchablePaddedStringField, this.unsearchablePaddedStringField, this.searchableDoubleField, this.searchableSortedStringField);
    }

    @Override
    public boolean skipsIndexingNull() {
        return this.skipsIndexingNull;
    }
}

