/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.issue.index.indexers.impl;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.vdi.CustomFieldPrefetchedData;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.impl.FieldIndexerUtil;
import com.atlassian.jira.search.Field;
import com.atlassian.jira.search.annotations.ExperimentalSearchApi;
import com.atlassian.jira.search.field.AbstractField;
import com.atlassian.jira.search.field.FieldValueCollector;
import com.atlassian.jira.search.field.KeywordField;
import com.atlassian.jira.search.issue.index.indexers.impl.BaseCustomFieldIndexer;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.Collection;
import java.util.stream.Stream;

@ExperimentalSearchApi
public class ExactTextCustomFieldIndexer
extends BaseCustomFieldIndexer {
    private final boolean skipIndexingNull;
    private final KeywordField sortField;

    public ExactTextCustomFieldIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField, boolean skipIndexingNull) {
        super(fieldVisibilityManager, customField, ExactTextCustomFieldIndexer.buildCustomField(customField));
        this.skipIndexingNull = skipIndexingNull;
        this.sortField = ExactTextCustomFieldIndexer.buildSortField(customField);
    }

    @Override
    public Collection<Field> getFields() {
        return Stream.concat(super.getFields().stream(), Stream.of(this.sortField)).toList();
    }

    @Override
    public boolean skipsIndexingNull() {
        return this.skipIndexingNull;
    }

    @Override
    public void indexFields(FieldValueCollector collector, Issue issue, CustomFieldPrefetchedData prefetchedData) {
        Object value = this.customField.getValue(issue);
        if (value != null) {
            String stringValue = this.customField.getCustomFieldType().getStringFromSingularObject(value);
            this.indexField(collector, stringValue, issue);
        }
        if (!this.skipIndexingNull) {
            String string = FieldIndexerUtil.getValueForSorting((String)value);
            collector.add(this.sortField.name(), string);
        }
    }

    private static KeywordField buildCustomField(CustomField customField) {
        return (KeywordField)((AbstractField.Builder)((AbstractField.Builder)KeywordField.builder(customField.getId()).indexed()).docValues()).stored().build();
    }

    private static KeywordField buildSortField(CustomField customField) {
        return (KeywordField)KeywordField.builder("sort_" + customField.getId()).docValues().build();
    }
}

