/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.issue.index.indexers.impl;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.search.Field;
import com.atlassian.jira.search.annotations.ExperimentalSearchSpi;
import com.atlassian.jira.search.field.DoubleField;
import com.atlassian.jira.search.field.KeywordField;
import com.atlassian.jira.search.field.LongField;
import com.atlassian.jira.search.issue.index.indexers.CustomFieldIndexer;
import com.atlassian.jira.search.issue.index.indexers.impl.VisibilityBaseFieldIndexer;
import com.atlassian.jira.web.FieldVisibilityManager;

@ExperimentalSearchSpi
public abstract class BaseCustomFieldIndexer
extends VisibilityBaseFieldIndexer
implements CustomFieldIndexer {
    protected final CustomField customField;

    protected BaseCustomFieldIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField, KeywordField visibleField) {
        super(fieldVisibilityManager, visibleField);
        this.customField = customField;
    }

    protected BaseCustomFieldIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField, DoubleField visibleField) {
        super(fieldVisibilityManager, visibleField);
        this.customField = customField;
    }

    protected BaseCustomFieldIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField, LongField visibleField) {
        super(fieldVisibilityManager, visibleField);
        this.customField = customField;
    }

    protected BaseCustomFieldIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField, Field visibleField, Field unsearchableField) {
        super(fieldVisibilityManager, visibleField, unsearchableField);
        this.customField = customField;
    }

    @Override
    public String getId() {
        return this.customField.getId();
    }

    @Override
    public boolean isFieldVisibleAndInScope(Issue issue) {
        return this.fieldVisibilityManager.isFieldVisible(this.getId(), issue) && this.customField.isRelevantForIssueContext(issue);
    }

    @Override
    public CustomField getCustomField() {
        return this.customField;
    }
}

