/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.issue;

import com.atlassian.jira.search.Query;
import com.atlassian.jira.search.aggregation.Aggregation;
import com.atlassian.jira.search.aggregation.AggregationsRequest;
import com.atlassian.jira.search.annotations.ExperimentalSearchApi;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ExperimentalSearchApi
public final class DocumentSearchRequest {
    private final ApplicationUser searcher;
    private final com.atlassian.query.Query jqlQuery;
    private final Query filterQuery;
    private final Collection<String> fieldsToLoad;
    private final boolean overrideSecurity;
    private final AggregationsRequest aggregations;

    private DocumentSearchRequest(ApplicationUser searcher, com.atlassian.query.Query jqlQuery, Query filterQuery, Collection<String> fieldsToLoad, boolean overrideSecurity, AggregationsRequest aggregations) {
        this.searcher = searcher;
        this.jqlQuery = Objects.requireNonNull(jqlQuery, "jqlQuery");
        this.filterQuery = filterQuery;
        this.fieldsToLoad = fieldsToLoad;
        this.overrideSecurity = overrideSecurity;
        this.aggregations = aggregations;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Nullable
    public ApplicationUser searcher() {
        return this.searcher;
    }

    @Nonnull
    public com.atlassian.query.Query jqlQuery() {
        return this.jqlQuery;
    }

    @Nullable
    public Query filterQuery() {
        return this.filterQuery;
    }

    @Nullable
    public Collection<String> fieldsToLoad() {
        return this.fieldsToLoad;
    }

    public boolean overrideSecurity() {
        return this.overrideSecurity;
    }

    @Nullable
    public AggregationsRequest aggregations() {
        return this.aggregations;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DocumentSearchRequest that = (DocumentSearchRequest)obj;
        return Objects.equals(this.searcher, that.searcher) && Objects.equals(this.jqlQuery, that.jqlQuery) && Objects.equals(this.filterQuery, that.filterQuery) && Objects.equals(this.fieldsToLoad, that.fieldsToLoad) && this.overrideSecurity == that.overrideSecurity && Objects.equals(this.aggregations, that.aggregations);
    }

    public int hashCode() {
        return Objects.hash(this.searcher, this.jqlQuery, this.filterQuery, this.fieldsToLoad, this.overrideSecurity, this.aggregations);
    }

    public String toString() {
        return "DocumentSearchRequest[searcher=" + String.valueOf(this.searcher) + ", jqlQuery=" + String.valueOf(this.jqlQuery) + ", filterQuery=" + String.valueOf(this.filterQuery) + ", fieldsToLoad=" + String.valueOf(this.fieldsToLoad) + ", overrideSecurity=" + this.overrideSecurity + ", aggregations=" + String.valueOf(this.aggregations) + "]";
    }

    public static class Builder {
        private ApplicationUser searcher;
        private com.atlassian.query.Query jqlQuery;
        private Query filterQuery;
        private boolean overrideSecurity;
        private Collection<String> fieldsToLoad;
        private final AggregationsRequest.Builder aggregations = AggregationsRequest.builder();

        public Builder searcher(@Nullable ApplicationUser searcher) {
            this.searcher = searcher;
            return this;
        }

        public Builder jqlQuery(@Nonnull com.atlassian.query.Query jqlQuery) {
            this.jqlQuery = jqlQuery;
            return this;
        }

        public Builder filterQuery(@Nullable Query filterQuery) {
            this.filterQuery = filterQuery;
            return this;
        }

        public Builder fieldsToLoad(@Nullable Collection<String> fieldsToLoad) {
            this.fieldsToLoad = fieldsToLoad;
            return this;
        }

        public Builder overrideSecurity(boolean overrideSecurity) {
            this.overrideSecurity = overrideSecurity;
            return this;
        }

        public Builder aggregation(String name, Aggregation aggregation) {
            this.aggregations.put(name, aggregation);
            return this;
        }

        public Builder aggregations(Map<String, Aggregation> aggregations) {
            this.aggregations.putAll(aggregations);
            return this;
        }

        public DocumentSearchRequest build() {
            return new DocumentSearchRequest(this.searcher, this.jqlQuery, this.filterQuery, this.fieldsToLoad, this.overrideSecurity, this.aggregations.build());
        }
    }
}

