/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.index;

import com.atlassian.jira.search.annotations.ExperimentalSearchApi;
import com.atlassian.jira.search.field.FieldValue;
import com.atlassian.jira.search.index.IndexRequest;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;

@ExperimentalSearchApi
public final class UpdateBulkRequest {
    private final Set<IndexRequest> updateRequests;

    private UpdateBulkRequest(Builder builder) {
        this.updateRequests = builder.bulkBuilder.build();
    }

    public Set<IndexRequest> getRequests() {
        return this.updateRequests;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final ImmutableSet.Builder<IndexRequest> bulkBuilder = ImmutableSet.builder();

        public Builder put(String documentId, List<FieldValue> values) {
            return this.put(IndexRequest.builder(documentId).values(values).build());
        }

        public Builder put(String documentId, long version, List<FieldValue> values) {
            return this.put(IndexRequest.builder(documentId, version).values(values).build());
        }

        public Builder put(IndexRequest request) {
            this.bulkBuilder.add((Object)request);
            return this;
        }

        public UpdateBulkRequest build() {
            return new UpdateBulkRequest(this);
        }

        public Builder putAll(Set<IndexRequest> indexRequests) {
            this.bulkBuilder.addAll(indexRequests);
            return this;
        }
    }
}

