/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.field;

import com.atlassian.jira.search.Document;
import com.atlassian.jira.search.FieldVisitor;
import com.atlassian.jira.search.TypedField;
import com.atlassian.jira.search.annotations.ExperimentalSearchApi;
import com.atlassian.jira.search.field.FieldValue;
import com.atlassian.jira.search.field.JoinFieldValue;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

@ExperimentalSearchApi
public class JoinField
implements TypedField<JoinFieldValue> {
    public static final String JOIN_FIELD_NAME = "_join";
    private final Map<String, Collection<String>> relations;

    private JoinField(Builder builder) {
        this.relations = ImmutableMap.copyOf(builder.relations);
    }

    @Override
    public String name() {
        return JOIN_FIELD_NAME;
    }

    public Map<String, Collection<String>> relations() {
        return this.relations;
    }

    @Override
    public <T> T accept(FieldVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public Class<JoinFieldValue> getValueType() {
        return JoinFieldValue.class;
    }

    @Override
    public List<JoinFieldValue> get(Document document) {
        return Collections.emptyList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JoinField that = (JoinField)o;
        return Objects.equals(this.relations, that.relations);
    }

    public int hashCode() {
        return Objects.hash(this.name(), this.relations);
    }

    public String toString() {
        return "JoinField{name=" + this.name() + ", relations=" + String.valueOf(this.relations) + "}";
    }

    public static FieldValue createParentFieldValue(String parentDocumentType) {
        return new FieldValue(JOIN_FIELD_NAME, new JoinFieldValue(parentDocumentType));
    }

    public static FieldValue createChildFieldValue(String childDocumentType, String parentDocumentId) {
        return new FieldValue(JOIN_FIELD_NAME, new JoinFieldValue(childDocumentType, parentDocumentId));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Map<String, HashSet<String>> relations = new HashMap<String, HashSet<String>>();

        public Builder relations(Map<String, Collection<String>> relations) {
            this.relations = relations.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new HashSet((Collection)e.getValue())));
            return this;
        }

        public JoinField build() {
            return new JoinField(this);
        }
    }
}

