/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.field;

import com.atlassian.jira.search.Document;
import com.atlassian.jira.search.FieldVisitor;
import com.atlassian.jira.search.annotations.ExperimentalSearchApi;
import com.atlassian.jira.search.field.AbstractField;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;

@ExperimentalSearchApi
public final class AnalyzedTextField
extends AbstractField<String> {
    private final boolean concatenated;

    private AnalyzedTextField(Builder builder) {
        super(builder);
        this.concatenated = builder.concatenated;
    }

    @Override
    public <T> T accept(FieldVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public boolean isConcatenated() {
        return this.concatenated;
    }

    @Override
    public Class<String> getValueType() {
        return String.class;
    }

    @Override
    public List<String> get(Document document) {
        return document.getStrings(this.name());
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && ((AnalyzedTextField)o).concatenated == this.concatenated;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name(), this.isConcatenated(), this.isIndexed(), this.isStored(), this.isMultiValued());
    }

    @Override
    protected ToStringBuilder toStringBuilder() {
        return super.toStringBuilder().append("concatenated", this.concatenated);
    }

    public static Builder builder(String fieldName) {
        return new Builder(fieldName);
    }

    public static final class Builder
    extends AbstractField.Builder<AnalyzedTextField> {
        private boolean concatenated;

        private Builder(String fieldName) {
            super(fieldName);
        }

        public Builder concatenated() {
            this.concatenated = true;
            return this;
        }

        @Override
        public Builder docValues() {
            throw new IllegalArgumentException("AnalyzedTextField does not support Doc Values.");
        }

        @Override
        public AnalyzedTextField build() {
            return new AnalyzedTextField(this);
        }
    }
}

