/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.exception;

import com.atlassian.jira.search.annotations.ExperimentalSearchApi;
import com.atlassian.jira.search.exception.IndexOperationException;
import java.util.Map;
import java.util.Optional;

@ExperimentalSearchApi
public class BulkIndexOperationsException
extends IndexOperationException {
    private final Map<String, IndexOperationException> documentExceptions;

    public BulkIndexOperationsException(String message, Map<String, IndexOperationException> documentExceptions) {
        super(String.format("%s, on documents %s", message, documentExceptions));
        this.documentExceptions = documentExceptions;
    }

    public Map<String, IndexOperationException> getDocumentExceptions() {
        return this.documentExceptions;
    }

    public Optional<IndexOperationException> getDocumentException(String documentId) {
        return Optional.ofNullable(this.documentExceptions.get(documentId));
    }
}

