/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.aggregation.twodimensional;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.search.aggregation.twodimensional.Statistic;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

@Internal
public class TwoDimensionalStatistics {
    static final TwoDimensionalStatistics EMPTY = new TwoDimensionalStatistics(0L, 0L, 0L, 0L, Map.of(), List.of(), List.of());
    private final long hitCount;
    private final long xIrrelevant;
    private final long yIrrelevant;
    private final long bothIrrelevant;
    private final Map<Statistic, Map<Object, Statistic>> rowToColumnValuesMap;
    private final List<Statistic> xValueTotals;
    private final List<Statistic> yValueTotals;

    public TwoDimensionalStatistics(long hitCount, long xIrrelevant, long yIrrelevant, long bothIrrelevant, Map<Statistic, Map<Object, Statistic>> rowToColumnValuesMap, List<Statistic> xValueTotals, List<Statistic> yValueTotals) {
        this.hitCount = hitCount;
        this.xIrrelevant = xIrrelevant;
        this.yIrrelevant = yIrrelevant;
        this.bothIrrelevant = bothIrrelevant;
        this.rowToColumnValuesMap = rowToColumnValuesMap;
        this.xValueTotals = xValueTotals;
        this.yValueTotals = yValueTotals;
    }

    public Map<Statistic, Map<Object, Statistic>> getRowToColumnValuesMap() {
        return this.rowToColumnValuesMap;
    }

    public List<Statistic> getXValueTotals(Comparator<Statistic> comparator) {
        if (!this.xValueTotals.isEmpty()) {
            this.xValueTotals.sort(comparator);
        }
        return this.xValueTotals;
    }

    public List<Statistic> getXValueTotals() {
        return this.xValueTotals;
    }

    public List<Statistic> getYValueTotals(Comparator<Statistic> comparator) {
        if (!this.yValueTotals.isEmpty()) {
            this.yValueTotals.sort(comparator);
        }
        return this.yValueTotals;
    }

    public List<Statistic> getYValueTotals() {
        return this.yValueTotals;
    }

    public long getHitCount() {
        return this.hitCount;
    }

    public long getBothIrrelevant() {
        return this.bothIrrelevant;
    }

    public boolean hasIrrelevantXData() {
        return this.xIrrelevant > 0L;
    }

    public boolean hasIrrelevantYData() {
        return this.yIrrelevant > 0L;
    }

    public boolean hasBothIrrelevantData() {
        return this.bothIrrelevant > 0L;
    }

    public long getxIrrelevant() {
        return this.xIrrelevant;
    }

    public long getYIrrelevant() {
        return this.yIrrelevant;
    }
}

