/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.aggregation.bucket.range;

import com.atlassian.jira.search.aggregation.Aggregation;
import com.atlassian.jira.search.aggregation.AggregationsRequest;
import com.atlassian.jira.search.aggregation.bucket.BucketAggregation;
import com.atlassian.jira.search.aggregation.bucket.range.Range;
import com.atlassian.jira.search.annotations.ExperimentalSearchApi;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ExperimentalSearchApi
public class RangeAggregation
implements BucketAggregation {
    private final String field;
    private final List<Range> ranges;
    private final AggregationsRequest subAggregations;

    private RangeAggregation(String field, List<Range> ranges, AggregationsRequest subAggregations) {
        this.field = Objects.requireNonNull(field, "field is required");
        this.ranges = List.copyOf(ranges);
        this.subAggregations = subAggregations;
    }

    @Override
    public AggregationsRequest getSubAggregations() {
        return this.subAggregations;
    }

    public String getField() {
        return this.field;
    }

    public List<Range> getRanges() {
        return this.ranges;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RangeAggregation that = (RangeAggregation)o;
        return Objects.equals(this.field, that.field) && Objects.equals(this.ranges, that.ranges) && Objects.equals(this.subAggregations, that.subAggregations);
    }

    public int hashCode() {
        return Objects.hash(this.field, this.ranges, this.subAggregations);
    }

    public static class Builder {
        private String field;
        private final AggregationsRequest.Builder subAggregations = AggregationsRequest.builder();
        private final List<Range> ranges = new ArrayList<Range>();

        public Builder withField(String field) {
            this.field = field;
            return this;
        }

        public Builder withSubAggregation(String name, Aggregation aggregation) {
            this.subAggregations.put(name, aggregation);
            return this;
        }

        public Builder withSubAggregations(Map<String, Aggregation> aggregations) {
            this.subAggregations.putAll(aggregations);
            return this;
        }

        public Builder addRanges(List<Range> ranges) {
            this.ranges.addAll(ranges);
            return this;
        }

        public Builder addRange(@Nullable Double from, @Nullable Double to) {
            this.ranges.add(Range.of(from, to));
            return this;
        }

        public Builder addRange(@Nullable Long from, @Nullable Long to) {
            this.ranges.add(Range.of(from != null ? Double.valueOf(from.doubleValue()) : null, to != null ? Double.valueOf(to.doubleValue()) : null));
            return this;
        }

        public RangeAggregation build() {
            return new RangeAggregation(this.field, this.ranges, this.subAggregations.build());
        }
    }
}

