/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.aggregation.bucket.filter;

import com.atlassian.jira.search.Query;
import com.atlassian.jira.search.aggregation.Aggregation;
import com.atlassian.jira.search.aggregation.AggregationsRequest;
import com.atlassian.jira.search.aggregation.bucket.BucketAggregation;
import com.atlassian.jira.search.annotations.ExperimentalSearchApi;
import java.util.Map;
import java.util.Objects;

@ExperimentalSearchApi
public final class FilterAggregation
implements BucketAggregation {
    private final Query filter;
    private final AggregationsRequest subAggregations;

    private FilterAggregation(Query filter, AggregationsRequest subAggregations) {
        this.filter = filter;
        this.subAggregations = subAggregations;
    }

    public Query getFilter() {
        return this.filter;
    }

    @Override
    public AggregationsRequest getSubAggregations() {
        return this.subAggregations;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilterAggregation that = (FilterAggregation)o;
        return Objects.equals(this.filter, that.filter) && Objects.equals(this.subAggregations, that.subAggregations);
    }

    public int hashCode() {
        return Objects.hash(this.filter, this.subAggregations);
    }

    public static final class Builder {
        private Query filter;
        private final AggregationsRequest.Builder subAggregations = AggregationsRequest.builder();

        private Builder() {
        }

        public Builder withFilter(Query filter) {
            this.filter = filter;
            return this;
        }

        public Builder withSubAggregation(String name, Aggregation aggregation) {
            this.subAggregations.put(name, aggregation);
            return this;
        }

        public Builder withSubAggregations(Map<String, Aggregation> aggregations) {
            this.subAggregations.putAll(aggregations);
            return this;
        }

        public FilterAggregation build() {
            return new FilterAggregation(this.filter, this.subAggregations.build());
        }
    }
}

