/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.aggregation.bucket.datehistogram;

import com.atlassian.jira.search.aggregation.Aggregation;
import com.atlassian.jira.search.aggregation.AggregationsRequest;
import com.atlassian.jira.search.aggregation.bucket.BucketAggregation;
import com.atlassian.jira.search.aggregation.bucket.datehistogram.Interval;
import com.atlassian.jira.search.annotations.ExperimentalSearchApi;
import java.time.ZoneId;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@ExperimentalSearchApi
public class DateHistogramAggregation
implements BucketAggregation {
    private final String field;
    private final Interval interval;
    private final ZoneId zoneId;
    private final AggregationsRequest subAggregations;

    private DateHistogramAggregation(String field, Interval interval, @Nullable ZoneId zoneId, AggregationsRequest subAggregations) {
        this.field = Objects.requireNonNull(field, "field is required");
        this.interval = Objects.requireNonNull(interval, "interval is required");
        this.zoneId = zoneId;
        this.subAggregations = subAggregations;
    }

    @Override
    public AggregationsRequest getSubAggregations() {
        return this.subAggregations;
    }

    public Optional<ZoneId> getZoneId() {
        return Optional.ofNullable(this.zoneId);
    }

    public String getField() {
        return this.field;
    }

    public Interval getInterval() {
        return this.interval;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateHistogramAggregation that = (DateHistogramAggregation)o;
        return Objects.equals(this.field, that.field) && Objects.equals(this.interval, that.interval) && Objects.equals(this.zoneId, that.zoneId) && Objects.equals(this.subAggregations, that.subAggregations);
    }

    public int hashCode() {
        return Objects.hash(this.field, this.interval, this.zoneId, this.subAggregations);
    }

    public static class Builder {
        private String field;
        private Interval interval;
        private ZoneId zoneId;
        private final AggregationsRequest.Builder subAggregations = AggregationsRequest.builder();

        private Builder() {
        }

        public Builder withField(String field) {
            this.field = field;
            return this;
        }

        public Builder withInterval(Interval interval) {
            this.interval = interval;
            return this;
        }

        public Builder withZoneId(@Nullable ZoneId zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public Builder withSubAggregation(String name, Aggregation aggregation) {
            this.subAggregations.put(name, aggregation);
            return this;
        }

        public Builder withSubAggregations(Map<String, Aggregation> aggregations) {
            this.subAggregations.putAll(aggregations);
            return this;
        }

        public DateHistogramAggregation build() {
            return new DateHistogramAggregation(this.field, this.interval, this.zoneId, this.subAggregations.build());
        }
    }
}

