/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search;

import com.atlassian.jira.search.annotations.ExperimentalSearchApi;
import java.util.Locale;

@ExperimentalSearchApi
public interface FieldSort {
    public String field();

    public Order order();

    public static enum Order {
        ASCENDING("ASC"),
        DESCENDING("DESC");

        private final String jqlString;

        private Order(String jqlString) {
            this.jqlString = jqlString;
        }

        public String getJqlString() {
            return this.jqlString;
        }

        public static Order parseString(String value) {
            String fold = value.toUpperCase(Locale.ENGLISH);
            for (Order order : Order.values()) {
                if (!order.getJqlString().equals(fold)) continue;
                return order;
            }
            return ASCENDING;
        }
    }
}

