/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search;

import com.atlassian.jira.search.FieldValueLoader;
import com.atlassian.jira.search.TypedField;
import com.atlassian.jira.search.annotations.ExperimentalSearchApi;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@ExperimentalSearchApi
public interface Document {
    public Collection<String> getFieldNames();

    public Optional<String> getString(String var1);

    public List<String> getStrings(String var1);

    public Optional<Number> getNumber(String var1);

    public List<Number> getNumbers(String var1);

    default public <T> List<T> get(TypedField<T> field) {
        return Assertions.notNull("field", field).get(this);
    }

    default public <T> Optional<T> getValue(FieldValueLoader<T> loader) {
        Assertions.notNull("loader", loader);
        return this.getString(loader.field()).map(loader::loadValue);
    }

    default public <T> List<T> getValues(FieldValueLoader<T> loader) {
        Assertions.notNull("loader", loader);
        return this.getStrings(loader.field()).stream().map(loader::loadValue).filter(Objects::nonNull).sorted(loader.getComparator()).toList();
    }
}

