/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.annotations.Internal;
import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.entity.WithId;
import com.atlassian.jira.entity.WithKey;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.Named;
import com.atlassian.jira.util.NamedWithDescription;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericValue;

@PublicApi
public interface Project
extends Named,
NamedWithDescription,
WithId,
WithKey {
    @Override
    public Long getId();

    @Override
    public String getName();

    @Override
    public String getKey();

    public String getUrl();

    public String getEmail();

    public ApplicationUser getLead();

    public String getLeadUserName();

    @Override
    public String getDescription();

    public Long getAssigneeType();

    public ProjectTypeKey getProjectTypeKey();

    public Collection<ProjectComponent> getComponents();

    public Collection<ProjectComponent> getProjectComponents();

    public Collection<Version> getVersions();

    public Collection<IssueType> getIssueTypes();

    public ProjectCategory getProjectCategory();

    public ProjectCategory getProjectCategoryObject();

    public GenericValue getGenericValue();

    @Nonnull
    public Avatar getAvatar();

    @Nullable
    public ApplicationUser getProjectLead();

    @Nullable
    public String getLeadUserKey();

    @Internal
    public String getOriginalKey();

    @ExperimentalApi
    public boolean isArchived();

    @ExperimentalApi
    public ApplicationUser getArchivedBy();

    @ExperimentalApi
    public Date getArchivedDate();

    @Nullable
    default public Timestamp getCreatedAt() {
        return null;
    }

    @Nullable
    default public Long getCreatorId() {
        return null;
    }

    @Nullable
    default public ApplicationUser getCreatedBy() {
        return null;
    }

    @Nullable
    default public Timestamp getLastUpdatedAt() {
        return null;
    }

    @Nullable
    default public Long getLastUpdaterId() {
        return null;
    }

    @Nullable
    default public ApplicationUser getLastUpdatedBy() {
        return null;
    }

    @Nullable
    default public String getReplyToEmail() {
        return null;
    }
}

