/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.statistics;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchRequestAppender;
import com.atlassian.jira.issue.statistics.FilterStatisticsValuesGenerator;
import com.atlassian.jira.issue.statistics.StatisticMapWrapper;
import com.atlassian.jira.issue.statistics.StatisticsMapper;
import com.atlassian.jira.issue.statistics.util.ComparatorSelector;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.plugin.util.TabPanelUtil;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.search.aggregation.bucket.Bucket;
import com.atlassian.jira.search.aggregation.bucket.filter.FilterAggregation;
import com.atlassian.jira.search.aggregation.bucket.terms.TermsAggregation;
import com.atlassian.jira.search.issue.DocumentSearchRequest;
import com.atlassian.jira.search.issue.IssueDocumentSearchService;
import com.atlassian.jira.search.query.DefaultBooleanQuery;
import com.atlassian.jira.search.query.DefaultTermQuery;
import com.atlassian.jira.search.request.PageRequest;
import com.atlassian.jira.search.response.SearchResponse;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.Clause;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.ofbiz.core.entity.GenericValue;

@Internal
public class StatisticsMapGenerator {
    private ApplicationUser remoteUser;
    private SearchRequest filter;
    private final boolean overrideSecurity;
    private final SearchService searchService = ComponentAccessor.getComponent(SearchService.class);
    private final IssueDocumentSearchService issueDocumentSearchService = ComponentAccessor.getComponent(IssueDocumentSearchService.class);
    private static final Comparator<Map.Entry<String, Integer>> mapEntryComparator = new Comparator<Map.Entry<String, Integer>>(){

        @Override
        public int compare(Map.Entry<String, Integer> e1, Map.Entry<String, Integer> e2) {
            Integer v2;
            Integer v1 = e1.getValue();
            int result = v1.compareTo(v2 = e2.getValue());
            if (result == 0) {
                String k1 = e1.getKey();
                String k2 = e2.getKey();
                if (k1 == null && k2 == null) {
                    return 0;
                }
                if (k1 == null) {
                    return 1;
                }
                if (k2 == null) {
                    return -1;
                }
                result = k1.compareTo(k2);
            }
            return result;
        }
    };

    public StatisticsMapGenerator() {
        this.overrideSecurity = false;
    }

    public StatisticsMapGenerator(ApplicationUser remoteUser, SearchRequest filter) {
        this.remoteUser = remoteUser;
        this.filter = filter;
        this.overrideSecurity = false;
    }

    public StatisticsMapGenerator(ApplicationUser remoteUser, SearchRequest filter, boolean overrideSecurity) {
        this.remoteUser = remoteUser;
        this.filter = filter;
        this.overrideSecurity = overrideSecurity;
    }

    public StatisticsMapGenerator(ApplicationUser remoteUser, Long projectId, boolean limitToOpenIssues) {
        this.remoteUser = remoteUser;
        this.filter = this.getProjectFilter(projectId, limitToOpenIssues);
        this.overrideSecurity = false;
    }

    public StatisticsMapGenerator(ApplicationUser remoteUser, Long projectId) {
        this(remoteUser, projectId, true);
    }

    public StatisticsMapGenerator(ApplicationUser remoteUser, Long projectId, Clause additionalClause, boolean limitToOpenIssues) {
        this(remoteUser, projectId, limitToOpenIssues);
        if (additionalClause != null) {
            this.addAdditionalParameters(this.filter, additionalClause);
        }
    }

    private SearchRequest getProjectFilter(Long projectId, boolean limitToOpenIssues) {
        JqlClauseBuilder builder = JqlQueryBuilder.newBuilder().where().defaultAnd();
        if (limitToOpenIssues) {
            builder.unresolved();
        }
        builder.project(projectId);
        return new SearchRequest(builder.buildQuery());
    }

    private void addAdditionalParameters(SearchRequest sr, Clause additionalClause) {
        JqlQueryBuilder query = JqlQueryBuilder.newBuilder(sr.getQuery());
        query.where().defaultAnd().addClause(additionalClause);
        sr.setQuery(query.buildQuery());
    }

    public SearchRequest getFilter() {
        return this.filter;
    }

    public StatisticMapWrapper generateStatisticMapWrapper(StatisticsMapper mapper) throws SearchException {
        return this.generateStatisticMapWrapper(mapper, null, null);
    }

    public StatisticMapWrapper generateStatisticMapWrapper(StatisticsMapper mapper, OrderBy orderBy, Direction direction) throws SearchException {
        Set<Map.Entry<String, Integer>> mapEntrySet;
        AbstractMap map;
        SearchStatisticsResult statisticsResult = this.searchCountMap(mapper.field());
        Map<String, Integer> groupedCounts = statisticsResult.getStatistics();
        long numberOfissues = statisticsResult.getNumberOfIssues();
        if (orderBy != null && OrderBy.TOTAL.equals(orderBy)) {
            map = new LinkedHashMap();
            mapEntrySet = new TreeSet<Map.Entry<String, Integer>>(this.getDirectionalComparator(mapEntryComparator, direction));
            mapEntrySet.addAll(groupedCounts.entrySet());
        } else {
            Comparator comparator = ComparatorSelector.getComparator(mapper);
            map = comparator != null ? new TreeMap(this.getDirectionalComparator(comparator, direction)) : new HashMap();
            mapEntrySet = groupedCounts.entrySet();
        }
        for (Map.Entry<String, Integer> entry : mapEntrySet) {
            String fieldValue = entry.getKey();
            Object objectValue = mapper.loadValue(fieldValue);
            if (!mapper.isValidValue(objectValue)) continue;
            if (map.containsKey(objectValue)) {
                Integer currentValue = (Integer)map.get(objectValue);
                map.put(objectValue, entry.getValue() + currentValue);
                continue;
            }
            map.put(objectValue, entry.getValue());
        }
        return new StatisticMapWrapper(map, numberOfissues, statisticsResult.getNumberOfIrrelevantResults());
    }

    private <T> Comparator<T> getDirectionalComparator(Comparator<T> c, Direction direction) {
        if (direction != null && Direction.DESC.equals(direction)) {
            return new ReverseComparator(c);
        }
        return c;
    }

    protected SearchStatisticsResult searchCountMap(String groupField) throws SearchException {
        FilterAggregation irrelevantFilter = FilterAggregation.builder().withFilter(DefaultBooleanQuery.mustNot(new DefaultTermQuery("visiblefieldids", groupField))).build();
        String groupByAggregation = "groupBy";
        String irrelevantAggregation = "irrelevant";
        DocumentSearchRequest searchRequest = DocumentSearchRequest.builder().overrideSecurity(this.overrideSecurity).searcher(this.remoteUser).jqlQuery(this.filter.getQuery()).aggregation("groupBy", TermsAggregation.builder().withField(groupField).build()).aggregation("irrelevant", irrelevantFilter).fieldsToLoad(List.of(groupField)).build();
        SearchResponse searchResponse = this.issueDocumentSearchService.search(searchRequest, PageRequest.of(0, 0));
        long irrelevantCount = searchResponse.getAggregations().getFilter("irrelevant").getDocCount();
        int docCountWithTerms = 0;
        HashMap<String, Integer> stats = new HashMap<String, Integer>();
        for (Bucket bucket : searchResponse.getAggregations().getTerms("groupBy").getBuckets()) {
            String key = bucket.getKey();
            int docCount = (int)bucket.getDocCount();
            docCountWithTerms += docCount;
            stats.merge(key, docCount, Integer::sum);
        }
        if (searchResponse.getTotalHits() > (long)docCountWithTerms + irrelevantCount) {
            long missingCount = searchResponse.getTotalHits() - (long)docCountWithTerms - irrelevantCount;
            stats.put(null, (int)missingCount);
        }
        return new SearchStatisticsResult(searchResponse.getTotalHits(), irrelevantCount, stats);
    }

    public long getOpenByComponent() throws SearchException {
        return this.getOpenByComponent(null);
    }

    public long getOpenByComponent(GenericValue component) throws SearchException {
        if (component != null) {
            return this.getCountWithClause(JqlQueryBuilder.newClauseBuilder().component(component.getLong("id")).buildClause());
        }
        return this.getCountWithClause(JqlQueryBuilder.newClauseBuilder().componentIsEmpty().buildClause());
    }

    public long getOpenByFixFor() throws SearchException {
        return this.getOpenByFixFor(null);
    }

    public long getOpenByFixFor(Version version) throws SearchException {
        if (version != null) {
            return this.getCountWithClause(JqlQueryBuilder.newClauseBuilder().fixVersion(version.getId()).buildClause());
        }
        return this.getCountWithClause(JqlQueryBuilder.newClauseBuilder().fixVersionIsEmpty().buildClause());
    }

    public long getCount() throws SearchException {
        if (this.overrideSecurity) {
            return this.searchService.searchCountOverrideSecurity(this.remoteUser, this.filter.getQuery());
        }
        return this.searchService.searchCount(this.remoteUser, this.filter.getQuery());
    }

    public Collection getIssues() throws SearchException {
        if (this.overrideSecurity) {
            return this.searchService.searchOverrideSecurity(this.remoteUser, this.filter.getQuery(), TabPanelUtil.PAGER_FILTER).getResults();
        }
        return this.searchService.search(this.remoteUser, this.filter.getQuery(), TabPanelUtil.PAGER_FILTER).getResults();
    }

    private long getCountWithClause(Clause clause) throws SearchException {
        JqlQueryBuilder builder = JqlQueryBuilder.newBuilder(this.filter.getQuery());
        JqlClauseBuilder whereClauseBuilder = builder.where().defaultAnd();
        whereClauseBuilder.addClause(clause);
        if (this.overrideSecurity) {
            return this.searchService.searchCountOverrideSecurity(this.remoteUser, whereClauseBuilder.buildQuery());
        }
        return this.searchService.searchCount(this.remoteUser, whereClauseBuilder.buildQuery());
    }

    public StatisticMapWrapper getAllFilterBy(String type) throws SearchException {
        return this.generateStatisticMapWrapper(this.getMapper(type));
    }

    public StatisticMapWrapper getAllFilterBy(String type, OrderBy orderBy, Direction direction) throws SearchException {
        return this.generateStatisticMapWrapper(this.getMapper(type), orderBy, direction);
    }

    public StatisticsMapper getMapper(String type) {
        return new FilterStatisticsValuesGenerator().getStatsMapper(type);
    }

    public SearchRequestAppender getSearchRequestAppender(String statisticType) {
        StatisticsMapper statisticsMapper = this.getMapper(statisticType);
        if (statisticsMapper instanceof SearchRequestAppender.Factory) {
            return ((SearchRequestAppender.Factory)((Object)statisticsMapper)).getSearchRequestAppender();
        }
        return new StatisticMapperWrappingSearchRequestAppender(statisticsMapper);
    }

    public static class OrderBy {
        public static final OrderBy TOTAL = new OrderBy("total");
        public static final OrderBy NATURAL = new OrderBy("natural");
        private final String description;

        public static OrderBy get(String orderBy) {
            return OrderBy.TOTAL.description.equals(orderBy) ? TOTAL : NATURAL;
        }

        private OrderBy(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }

    public static class Direction {
        public static final Direction ASC = new Direction("asc");
        public static final Direction DESC = new Direction("desc");
        private final String description;

        public static Direction get(String direction) {
            return Direction.DESC.description.equals(direction) ? DESC : ASC;
        }

        private Direction(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }

    protected static class SearchStatisticsResult {
        private final long numberOfIssues;
        private final long numberOfIrrelevantResults;
        private final Map<String, Integer> statistics;

        public SearchStatisticsResult(long numberOfIssues, long numberOfIrrelevantResults, Map<String, Integer> statistics) {
            this.numberOfIssues = numberOfIssues;
            this.numberOfIrrelevantResults = numberOfIrrelevantResults;
            this.statistics = statistics;
        }

        public long getNumberOfIssues() {
            return this.numberOfIssues;
        }

        public long getNumberOfIrrelevantResults() {
            return this.numberOfIrrelevantResults;
        }

        public Map<String, Integer> getStatistics() {
            return this.statistics;
        }
    }

    private static class StatisticMapperWrappingSearchRequestAppender<T>
    implements SearchRequestAppender<T> {
        private final StatisticsMapper<T> statisticsMapper;

        public StatisticMapperWrappingSearchRequestAppender(StatisticsMapper<T> statisticsMapper) {
            this.statisticsMapper = Assertions.notNull(statisticsMapper);
        }

        @Override
        public SearchRequest appendInclusiveSingleValueClause(T value, SearchRequest searchRequest) {
            return this.statisticsMapper.getSearchUrlSuffix(value, searchRequest);
        }

        @Override
        public SearchRequest appendExclusiveMultiValueClause(Iterable<? extends T> values, SearchRequest searchRequest) {
            return null;
        }
    }
}

