/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.charts.util;

import com.atlassian.jira.charts.ChartFactory;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.search.aggregation.bucket.datehistogram.Interval;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;

public class DataUtils {
    public static final int DAYS_LIMIT_DEFAULT = 1000;

    public static <T, N extends Number> Integer getTotalNumber(Map<T, N> data) {
        int total = 0;
        for (Number num : data.values()) {
            total += num.intValue();
        }
        return total;
    }

    public static <T> void normaliseMapKeys(Map<T, Number> map1, Map<T, Number> map2) {
        for (T key : map1.keySet()) {
            if (map2.containsKey(key)) continue;
            map2.put(key, 0);
        }
        for (T key : map2.keySet()) {
            if (map1.containsKey(key)) continue;
            map1.put(key, 0);
        }
    }

    public static <T> void makeCumulative(Map<T, Number> dataMap) {
        int total = 0;
        for (Map.Entry<T, Number> entry : dataMap.entrySet()) {
            dataMap.put(entry.getKey(), total += entry.getValue().intValue());
        }
    }

    public static void normaliseDateRangeCount(Map<RegularTimePeriod, Number> dateMap, int days, Class<?> period, TimeZone timeZone) {
        DataUtils.normaliseDateRangeCountForCustomRange(dateMap, days, new Date(), period, timeZone);
    }

    public static void normaliseDateRange(Map<RegularTimePeriod, List<Long>> dateMap, int days, Class<?> period, TimeZone timeZone) {
        DataUtils.normaliseDateRange(dateMap, days, new Date(), period, timeZone);
    }

    public static void normaliseDateRange(Map<RegularTimePeriod, List<Long>> dateMap, int days, @Nullable Date endDate, Class<?> period, TimeZone timeZone) {
        for (RegularTimePeriod p : DataUtils.getNormalizedPeriods(days, endDate, timeZone, period)) {
            dateMap.computeIfAbsent(p, k -> Lists.newArrayList((Object[])new Long[]{0L}));
        }
    }

    public static void normaliseDateRangeCountForCustomRange(Map<RegularTimePeriod, Number> dateMap, int daysBackwards, @Nullable Date endDate, Class<?> period, TimeZone timeZone) {
        for (RegularTimePeriod p : DataUtils.getNormalizedPeriods(daysBackwards, endDate, timeZone, period)) {
            dateMap.putIfAbsent(p, 0);
        }
    }

    public static List<RegularTimePeriod> getNormalizedPeriods(int days, @Nullable Date endDate, TimeZone timeZone, Class<?> timePeriodClass) {
        Date endOfRange = endDate == null ? new Date() : endDate;
        ArrayList<RegularTimePeriod> normalizedPeriods = new ArrayList<RegularTimePeriod>();
        Calendar cal = new Calendar.Builder().setTimeZone(timeZone).setInstant(endOfRange).build();
        cal.add(5, -days);
        Date earliest = cal.getTime();
        RegularTimePeriod end = RegularTimePeriod.createInstance(timePeriodClass, (Date)endOfRange, (TimeZone)timeZone);
        for (RegularTimePeriod cursor = RegularTimePeriod.createInstance(timePeriodClass, (Date)earliest, (TimeZone)timeZone); cursor != null && cursor.compareTo((Object)end) <= 0; cursor = cursor.next()) {
            normalizedPeriods.add(cursor);
            cursor.peg(cal);
        }
        return normalizedPeriods;
    }

    public static TimeSeriesCollection reduceDataset(TimeSeriesCollection dataset, List rowKeysToKeep) {
        TimeSeriesCollection newDataSet = new TimeSeriesCollection();
        ArrayList timeSerieses = new ArrayList(dataset.getSeries());
        for (TimeSeries timeSeries : timeSerieses) {
            if (!rowKeysToKeep.contains(timeSeries.getKey())) continue;
            newDataSet.addSeries(timeSeries);
        }
        return newDataSet;
    }

    public static int normalizeDaysValue(int days, ChartFactory.PeriodName period) {
        ApplicationProperties applicationProperties = ComponentAccessor.getComponent(ApplicationProperties.class);
        String limitString = applicationProperties.getDefaultBackedString("jira.chart.days.previous.limit." + period.toString());
        if (StringUtils.isNotEmpty((CharSequence)limitString)) {
            int limit = NumberUtils.toInt((String)limitString, (int)1000);
            return Math.max(Math.min(days, limit), 1);
        }
        return Math.max(Math.min(days, 1000), 1);
    }

    public static <T extends Comparable> CategoryDataset getCategoryDataset(List<Map<T, Number>> dataMaps, String[] seriesNames) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        if (dataMaps.size() != seriesNames.length) {
            throw new IllegalArgumentException("Number of datamaps and series names must be equal.");
        }
        for (int i = 0; i < seriesNames.length; ++i) {
            String seriesName = seriesNames[i];
            Map<T, Number> data = dataMaps.get(i);
            for (Map.Entry<T, Number> entry : data.entrySet()) {
                dataset.addValue(entry.getValue(), (Comparable)((Object)seriesName), (Comparable)entry.getKey());
            }
        }
        return dataset;
    }

    public static TimeSeriesCollection getTimeSeriesCollection(List<Map<RegularTimePeriod, Number>> dataMaps, String[] seriesNames, Class timePeriodClass) {
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        if (dataMaps.size() != seriesNames.length) {
            throw new IllegalArgumentException("Number of datamaps and series names must be equal.");
        }
        for (int i = 0; i < seriesNames.length; ++i) {
            String seriesName = seriesNames[i];
            TimeSeries series = new TimeSeries((Comparable)((Object)seriesName), timePeriodClass);
            Map<RegularTimePeriod, Number> data = dataMaps.get(i);
            for (Map.Entry<RegularTimePeriod, Number> entry : data.entrySet()) {
                series.add(entry.getKey(), entry.getValue());
            }
            dataset.addSeries(series);
        }
        return dataset;
    }

    public static Interval periodToInterval(ChartFactory.PeriodName periodName) {
        return switch (periodName) {
            case ChartFactory.PeriodName.hourly -> new Interval(Interval.CalendarUnit.HOUR);
            case ChartFactory.PeriodName.weekly -> new Interval(Interval.CalendarUnit.WEEK);
            case ChartFactory.PeriodName.monthly -> new Interval(Interval.CalendarUnit.MONTH);
            case ChartFactory.PeriodName.quarterly -> new Interval(Interval.CalendarUnit.QUARTER);
            case ChartFactory.PeriodName.yearly -> new Interval(Interval.CalendarUnit.YEAR);
            default -> new Interval(Interval.CalendarUnit.DAY);
        };
    }
}

