/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.charts;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.charts.Chart;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.user.ApplicationUser;
import javax.annotation.Nullable;

public interface ChartFactory {
    public static final int FRAGMENT_IMAGE_HEIGHT = 250;
    public static final int FRAGMENT_IMAGE_WIDTH = 380;
    public static final int PORTLET_IMAGE_HEIGHT = 300;
    public static final int PORTLET_IMAGE_WIDTH = 450;
    public static final int REPORT_IMAGE_HEIGHT = 500;
    public static final int REPORT_IMAGE_WIDTH = 800;

    public Chart generateCreatedVsResolvedChart(ChartContext var1, int var2, PeriodName var3, VersionLabel var4, boolean var5, boolean var6);

    @ExperimentalApi
    public Chart generateCreatedVsResolvedChart(ChartContext var1, int var2, @Nullable String var3, PeriodName var4, VersionLabel var5, boolean var6, boolean var7);

    public Chart generateDateRangeTimeChart(ChartContext var1, int var2, PeriodName var3, long var4, String var6, String var7);

    @ExperimentalApi
    public Chart generateDateRangeTimeChart(ChartContext var1, int var2, String var3, PeriodName var4, long var5, String var7, String var8);

    public Chart generatePieChart(ChartContext var1, String var2);

    public Chart generateAverageAgeChart(ChartContext var1, int var2, PeriodName var3);

    @ExperimentalApi
    public Chart generateAverageAgeChart(ChartContext var1, int var2, String var3, PeriodName var4);

    public Chart generateRecentlyCreated(ChartContext var1, int var2, PeriodName var3);

    @ExperimentalApi
    public Chart generateRecentlyCreated(ChartContext var1, int var2, String var3, PeriodName var4);

    public Chart generateTimeSinceChart(ChartContext var1, int var2, PeriodName var3, boolean var4, String var5);

    @ExperimentalApi
    public Chart generateTimeSinceChart(ChartContext var1, int var2, String var3, PeriodName var4, boolean var5, String var6);

    public static class ChartContext {
        private final ApplicationUser remoteUser;
        private final SearchRequest searchRequest;
        private final int width;
        private final int height;
        private final boolean inline;

        public ChartContext(ApplicationUser remoteUser, SearchRequest searchRequest, int width, int height, boolean inline) {
            this.remoteUser = remoteUser;
            this.searchRequest = searchRequest;
            this.width = width;
            this.height = height;
            this.inline = inline;
        }

        @Deprecated
        public ChartContext(ApplicationUser remoteUser, SearchRequest searchRequest, int width, int height) {
            this(remoteUser, searchRequest, width, height, false);
        }

        public int getHeight() {
            return this.height;
        }

        public ApplicationUser getRemoteUser() {
            return this.remoteUser;
        }

        public SearchRequest getSearchRequest() {
            return this.searchRequest;
        }

        public int getWidth() {
            return this.width;
        }

        public boolean isInline() {
            return this.inline;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChartContext that = (ChartContext)o;
            if (this.height != that.height) {
                return false;
            }
            if (this.width != that.width) {
                return false;
            }
            if (this.remoteUser != null ? !this.remoteUser.equals(that.remoteUser) : that.remoteUser != null) {
                return false;
            }
            if (this.searchRequest != null ? !this.searchRequest.equals(that.searchRequest) : that.searchRequest != null) {
                return false;
            }
            return this.inline == that.inline;
        }

        public int hashCode() {
            int result = this.remoteUser != null ? this.remoteUser.hashCode() : 0;
            result = 31 * result + (this.searchRequest != null ? this.searchRequest.hashCode() : 0);
            result = 31 * result + this.width;
            result = 31 * result + this.height;
            return result += this.inline ? 1 : 0;
        }
    }

    public static enum PeriodName {
        hourly,
        daily,
        weekly,
        monthly,
        quarterly,
        yearly;

    }

    public static enum VersionLabel {
        none,
        major,
        all;

    }
}

