/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.util.Page;
import com.atlassian.jira.util.PageRequest;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

@PublicApi
public class Pages {
    public static <T> Page<T> page(Iterable<T> values, long totalCount, PageRequest pageRequest) {
        ImmutableList valuesList = ImmutableList.copyOf(values);
        boolean isLast = pageRequest.getStart() + (long)valuesList.size() == totalCount;
        Preconditions.checkArgument((isLast || pageRequest.getLimit() == valuesList.size() ? 1 : 0) != 0, (Object)"Inconsistent arguments: this is not the last page and yet the number of values is different than the page limit");
        Preconditions.checkArgument(((long)valuesList.size() <= totalCount ? 1 : 0) != 0, (Object)"Inconsistent arguments: size of the page is greater than totalCount");
        return PageImpl.builder().setIsLast(isLast).setSize(valuesList.size()).setStart(pageRequest.getStart()).setTotal(totalCount).setValues(valuesList).build();
    }

    public static <T> Page<T> toPage(Iterable<T> allValues, PageRequest pageRequest) {
        return Pages.toPage(allValues, pageRequest, val -> true, Function.identity());
    }

    public static <T, R> Page<R> toPage(Iterable<T> values, PageRequest pageRequest, Predicate<T> filter, Function<T, R> transform) {
        List filtered = StreamSupport.stream(values.spliterator(), false).filter(filter).collect(Collectors.toList());
        List limitedWithOneExtra = filtered.stream().skip(pageRequest.getStart()).limit(pageRequest.getLimit() + 1).collect(Collectors.toList());
        boolean isLast = limitedWithOneExtra.size() < pageRequest.getLimit() + 1;
        ImmutableList valuesForPage = ImmutableList.copyOf(limitedWithOneExtra.stream().limit(pageRequest.getLimit()).map(transform).iterator());
        return PageImpl.builder().setValues(valuesForPage).setSize(Iterables.size((Iterable)valuesForPage)).setStart(pageRequest.getStart()).setTotal(Long.valueOf(filtered.size())).setIsLast(isLast).build();
    }

    private static final class PageImpl<T>
    implements Page<T> {
        private final long start;
        private final Long total;
        private final int size;
        private final boolean isLast;
        private final List<T> values;

        private PageImpl(long start, Long total, int size, boolean isLast, List<T> values) {
            this.start = start;
            this.total = total;
            this.size = size;
            this.isLast = isLast;
            this.values = values;
        }

        @Override
        public long getStart() {
            return this.start;
        }

        @Override
        public Long getTotal() {
            return this.total;
        }

        @Override
        public int getSize() {
            return this.size;
        }

        @Override
        public boolean isLast() {
            return this.isLast;
        }

        @Override
        public List<T> getValues() {
            return this.values;
        }

        public static <T> Builder<T> builder() {
            return new Builder();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PageImpl that = (PageImpl)o;
            return Objects.equal((Object)this.start, (Object)that.start) && Objects.equal((Object)this.total, (Object)that.total) && Objects.equal((Object)this.size, (Object)that.size) && Objects.equal((Object)this.isLast, (Object)that.isLast) && Objects.equal(this.values, that.values);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.start, this.total, this.size, this.isLast, this.values});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("start", this.start).add("total", (Object)this.total).add("size", this.size).add("hasNext", this.isLast).add("values", this.values).toString();
        }

        public static final class Builder<T> {
            private long start;
            private Long total;
            private int size;
            private boolean isLast;
            private List<T> values = ImmutableList.of();

            private Builder() {
            }

            public Builder<T> setStart(long start) {
                this.start = start;
                return this;
            }

            public Builder<T> setTotal(Long total) {
                this.total = total;
                return this;
            }

            public Builder<T> setSize(int size) {
                this.size = size;
                return this;
            }

            public Builder<T> setIsLast(boolean isLast) {
                this.isLast = isLast;
                return this;
            }

            public Builder<T> setValues(List<T> values) {
                this.values = values;
                return this;
            }

            public PageImpl<T> build() {
                return new PageImpl<T>(this.start, this.total, this.size, this.isLast, this.values);
            }
        }
    }
}

