/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.Visitor;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.concurrent.ConcurrentMap;

public class Functions {
    public static <T, R> Function<T, R> memoize(Function<T, R> function, ConcurrentMap<T, R> map) {
        return new Memoizer<T, R>(function, map);
    }

    public static <T> Function<T, T> identity() {
        return IdentityFunction.INSTANCE;
    }

    public static <T, V> Visitor<T> mappedVisitor(Function<T, V> mappingFunction, Visitor<V> delegate) {
        return new MappedVisitor<T, V>(mappingFunction, delegate);
    }

    public static <T, R extends T> Function<T, R> downcast(Class<R> subclass) {
        return new Downcaster(subclass);
    }

    public static <S, T extends S> Function<T, S> coerceToSuper() {
        return new Coercer();
    }

    static <T, R> Function<T, R> map(java.util.function.Function<T, R> input) {
        return new UtilConcurrentAdapter<T, R>(input);
    }

    public static <T, R> com.google.common.base.Function<T, R> toGoogleFunction(Function<T, R> function) {
        return new ToGoogleAdapter<T, R>(function);
    }

    static class Memoizer<T, R>
    implements Function<T, R> {
        private final Function<T, R> function;
        private final ConcurrentMap<T, R> map;

        Memoizer(Function<T, R> function, ConcurrentMap<T, R> map) {
            this.function = function;
            this.map = map;
        }

        @Override
        public R apply(T input) {
            Object result = this.map.get(input);
            while (result == null) {
                this.map.putIfAbsent(input, this.function.apply(input));
                result = this.map.get(input);
            }
            return (R)result;
        }
    }

    static class IdentityFunction<T>
    implements Function<T, T> {
        static final IdentityFunction<?> INSTANCE = new IdentityFunction();

        IdentityFunction() {
        }

        @Override
        public T apply(T input) {
            return input;
        }
    }

    static class MappedVisitor<T, V>
    implements Visitor<T> {
        private final Function<T, V> function;
        private final Visitor<V> delegate;

        MappedVisitor(Function<T, V> function, Visitor<V> delegate) {
            this.function = Assertions.notNull("function", function);
            this.delegate = Assertions.notNull("delegate", delegate);
        }

        @Override
        public void visit(T element) {
            this.delegate.visit(this.function.apply(element));
        }

        public String toString() {
            return "MappedVisitor[function=" + String.valueOf(this.function) + ",delegate=" + String.valueOf(this.delegate) + "]";
        }
    }

    static final class Downcaster<T, R extends T>
    implements Function<T, R> {
        private final Class<R> subclass;

        public Downcaster(Class<R> subclass) {
            this.subclass = Assertions.notNull("subclass", subclass);
        }

        @Override
        public R apply(T input) {
            return this.subclass.cast(input);
        }
    }

    static final class Coercer<S, T extends S>
    implements Function<T, S> {
        Coercer() {
        }

        @Override
        public S apply(T input) {
            return (S)input;
        }
    }

    static class UtilConcurrentAdapter<T, R>
    implements Function<T, R> {
        private final java.util.function.Function<T, R> delegate;

        UtilConcurrentAdapter(java.util.function.Function<T, R> delegate) {
            this.delegate = delegate;
        }

        @Override
        public R apply(T input) {
            return this.delegate.apply(input);
        }
    }

    static class ToGoogleAdapter<T, R>
    implements com.google.common.base.Function<T, R> {
        private final Function<T, R> delegate;

        ToGoogleAdapter(Function<T, R> delegate) {
            this.delegate = delegate;
        }

        public R apply(T from) {
            return this.delegate.apply(from);
        }
    }
}

