/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.util;

import com.atlassian.annotations.PublicApi;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.exception.AddException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Collection;
import java.util.Set;
import java.util.SortedSet;

@PublicApi
public interface UserUtil {
    public static final String META_PROPERTY_PREFIX = "jira.meta.";

    public void removeUser(ApplicationUser var1, ApplicationUser var2);

    public void addUserToGroup(Group var1, ApplicationUser var2) throws PermissionException, AddException;

    public void addUserToGroups(Collection<Group> var1, ApplicationUser var2) throws PermissionException, AddException;

    public void removeUserFromGroup(Group var1, ApplicationUser var2) throws PermissionException, RemoveException;

    public void removeUserFromGroups(Collection<Group> var1, ApplicationUser var2) throws PermissionException, RemoveException;

    public PasswordResetToken generatePasswordResetToken(ApplicationUser var1);

    public PasswordResetTokenValidation validatePasswordResetToken(ApplicationUser var1, String var2);

    public void changePassword(ApplicationUser var1, String var2) throws UserNotFoundException, InvalidCredentialException, OperationNotPermittedException, PermissionException;

    public boolean userExists(String var1);

    public Collection<ApplicationUser> getJiraAdministrators();

    public Collection<ApplicationUser> getJiraSystemAdministrators();

    public Collection<ProjectComponent> getComponentsUserLeads(ApplicationUser var1);

    public Collection<Project> getProjectsLeadBy(ApplicationUser var1);

    public boolean isNonSysAdminAttemptingToDeleteSysAdmin(ApplicationUser var1, ApplicationUser var2);

    public long getNumberOfReportedIssuesIgnoreSecurity(ApplicationUser var1, ApplicationUser var2) throws SearchException;

    public long getNumberOfAssignedIssuesIgnoreSecurity(ApplicationUser var1, ApplicationUser var2) throws SearchException;

    public String getDisplayableNameSafely(ApplicationUser var1);

    public SortedSet<Group> getGroupsForUser(String var1);

    public SortedSet<String> getGroupNamesForUser(String var1);

    public SortedSet<ApplicationUser> getAllUsersInGroupNames(Collection<String> var1);

    public Set<ApplicationUser> getAllUsersInGroupNamesUnsorted(Collection<String> var1);

    public SortedSet<ApplicationUser> getAllUsersInGroups(Collection<Group> var1);

    public static interface PasswordResetTokenValidation {
        public Status getStatus();

        public static enum Status {
            EXPIRED,
            UNEQUAL,
            OK;

        }
    }

    public static interface PasswordResetToken {
        public ApplicationUser getUser();

        public String getToken();

        public int getExpiryHours();

        public long getExpiryTime();
    }
}

