/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.parser;

import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public final class JqlParseErrorMessage {
    private final String key;
    private final List<?> arguments;
    private final int lineNumber;
    private final int columnNumber;

    public JqlParseErrorMessage(String key, int lineNumber, int columnNumber, Collection<?> arguments) {
        Assertions.containsNoNulls("arguments", arguments);
        this.key = Assertions.notBlank("key", key);
        this.arguments = CollectionUtil.copyAsImmutableList(arguments);
        this.lineNumber = lineNumber <= 0 ? -1 : lineNumber;
        this.columnNumber = columnNumber <= 0 ? -1 : columnNumber;
    }

    public JqlParseErrorMessage(String key, int lineNumber, int columnNumber, Object ... arguments) {
        this(key, lineNumber, columnNumber, Arrays.asList(Assertions.notNull("arguments", arguments)));
    }

    public String getKey() {
        return this.key;
    }

    public List<?> getArguments() {
        return this.arguments;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public String getLocalizedErrorMessage(I18nHelper helper) {
        Assertions.notNull("helper", helper);
        return helper.getText(this.key, this.arguments);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JqlParseErrorMessage that = (JqlParseErrorMessage)o;
        if (this.columnNumber != that.columnNumber) {
            return false;
        }
        if (this.lineNumber != that.lineNumber) {
            return false;
        }
        if (!this.arguments.equals(that.arguments)) {
            return false;
        }
        return this.key.equals(that.key);
    }

    public int hashCode() {
        int result = this.key.hashCode();
        result = 31 * result + this.arguments.hashCode();
        result = 31 * result + this.lineNumber;
        result = 31 * result + this.columnNumber;
        return result;
    }

    public String toString() {
        return "Error<" + this.lineNumber + ":" + this.columnNumber + "> - " + this.key + String.valueOf(this.arguments);
    }
}

