/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.util;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.DateField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.UserField;
import com.atlassian.jira.util.Predicate;
import com.atlassian.jira.util.Predicates;
import net.jcip.annotations.ThreadSafe;

@PublicApi
public final class FieldPredicates {
    private static final CustomFieldPredicate PREDICATE_CUSTOM_FIELD = new CustomFieldPredicate();
    private static final Predicate<Field> PREDICATE_DATE_FIELD = new CustomFieldTypePredicate(DateField.class);
    private static final Predicate<Field> PREDICATE_USER_FIELD = new CustomFieldTypePredicate(UserField.class);
    private static final Predicate<Field> PREDICATE_DATE_CUSTOM_FIELD = Predicates.allOf(PREDICATE_CUSTOM_FIELD, PREDICATE_DATE_FIELD);
    private static final Predicate<Field> PREDICATE_USER_CUSTOM_FIELD = Predicates.allOf(PREDICATE_CUSTOM_FIELD, PREDICATE_USER_FIELD);
    private static final Predicate<Field> PREDICATE_VIEW_ISSUE_FIELDS = Predicates.allOf(PREDICATE_CUSTOM_FIELD, Predicates.not(Predicates.anyOf(PREDICATE_DATE_FIELD, PREDICATE_USER_FIELD)));

    public static Predicate<Field> isCustomField() {
        return PREDICATE_CUSTOM_FIELD;
    }

    public static Predicate<Field> isDateField() {
        return PREDICATE_DATE_FIELD;
    }

    public static Predicate<Field> isUserField() {
        return PREDICATE_USER_FIELD;
    }

    public static Predicate<Field> isCustomUserField() {
        return PREDICATE_USER_CUSTOM_FIELD;
    }

    public static Predicate<Field> isCustomDateField() {
        return PREDICATE_DATE_CUSTOM_FIELD;
    }

    public static Predicate<Field> isStandardViewIssueCustomField() {
        return PREDICATE_VIEW_ISSUE_FIELDS;
    }

    @ThreadSafe
    private static class CustomFieldPredicate
    implements Predicate<Field> {
        private CustomFieldPredicate() {
        }

        @Override
        public boolean evaluate(Field input) {
            return input instanceof CustomField;
        }
    }

    @ThreadSafe
    private static class CustomFieldTypePredicate
    implements Predicate<Field> {
        private final Class<?> clazz;

        public CustomFieldTypePredicate(Class<?> clazz) {
            this.clazz = clazz;
        }

        @Override
        public boolean evaluate(Field input) {
            if (input instanceof CustomField) {
                return this.evaluateType(((CustomField)input).getCustomFieldType());
            }
            return this.evaluateType(input);
        }

        private boolean evaluateType(Object o) {
            return o != null && this.clazz.isAssignableFrom(o.getClass());
        }
    }
}

