/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.comparator;

import com.atlassian.jira.user.ApplicationUser;
import java.text.CollationKey;
import java.text.Collator;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;

public class UserNameComparator
implements Comparator<ApplicationUser> {
    private final HashMap<String, CollationKey> cache = new HashMap();
    private final Collator collator;

    public UserNameComparator(Locale locale) {
        this.collator = Collator.getInstance(locale);
        this.collator.setStrength(1);
    }

    @Override
    public int compare(ApplicationUser user1, ApplicationUser user2) {
        int result;
        if (user1 == user2) {
            return 0;
        }
        if (user2 == null) {
            return -1;
        }
        if (user1 == null) {
            return 1;
        }
        String left = user1.getName();
        String right = user2.getName();
        if (left == null || right == null) {
            throw new RuntimeException("Null user name");
        }
        if (!left.isEmpty() && !right.isEmpty() && (result = this.getLetterCollationKey(left).compareTo(this.getLetterCollationKey(right))) != 0) {
            return result;
        }
        return this.collator.compare(left, right);
    }

    private CollationKey getLetterCollationKey(String str) {
        String letter = str.isEmpty() ? " " : Character.toString(str.codePointAt(0));
        CollationKey key = this.cache.get(letter);
        if (key == null) {
            key = this.collator.getCollationKey(letter);
            this.cache.put(letter, key);
        }
        return key;
    }
}

